/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the STI Protocol Handler header file which is intended to be
 * included by the STI API as well as any Protocol driver implemented to
 * be implemented using STI. It is not intended to be included by Applications.
 *
 ******************************************************************************/

#ifndef STI_PROTOCOL_H_
#define STI_PROTOCOL_H_

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sti_api.h"
#include "sti_framework.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/*
    Called by STI Module
*/

STI_PROTOCOL_HDL STIP_hInstallProtocol (
    const STI_PROTOCOL_ENTRY_STRUCT *psProtocolEntry,
    STI_PROTOCOL_CALLBACK vCallback,
    void *pvCallbackArg
        );

BOOLEAN STIP_bUninstallProtocol (
    STI_PROTOCOL_HDL hProtocol
        );

/*
    Called by Protocol Specific Drivers
*/

const STI_PROTOCOL_ENTRY_STRUCT *STIP_psGetProtocolEntry(
    STI_PROTOCOL_HDL hProtocol
        );

BOOLEAN STIP_bGetProtocolData(
    STI_PROTOCOL_HDL hProtocol,
    void **ppvProtocolData
        );

OSAL_BUFFER_HDL STIP_hAllocateTxPayload (
    STI_PROTOCOL_HDL hProtocol
        );

OSAL_BUFFER_HDL STIP_hAllocateRxPayload (
    STI_PROTOCOL_HDL hProtocol
        );

STI_PROTOCOL_RESULT_CODE_ENUM STIP_eSendPayload (
    STI_HDL hSTI,
    STI_PROTOCOL_HDL hProtocol,
    BOOLEAN bBlock,
    OSAL_BUFFER_HDL hPayload,
    UN8 un8Retries,
    N32 n32Timeout
        );

BOOLEAN STIP_bReceivePayload (
    STI_PROTOCOL_HDL hProtocol,
    BOOLEAN bBlock,
    OSAL_BUFFER_HDL hPayload
        );

BOOLEAN STIP_bPostOOB (
    STI_PROTOCOL_HDL hProtocol,
    void *pvProtocolConnectionData,
    BOOLEAN bBlock,
    STI_OOB_TYPE_ENUM eType,
    void *pvEventData
        );

BOOLEAN STIP_bPostTimeout (
    STI_PROTOCOL_HDL hProtocol,
    STI_HDL hSTI,
    BOOLEAN bBlock
        );

BOOLEAN STIP_bSetError (
    STI_PROTOCOL_HDL hProtocol
        );

#endif /* STI_PROTOCOL_H */
