/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio Inc.               */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio Inc.      */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef WSI_PLATFORM_PORT_H_
#define WSI_PLATFORM_PORT_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "osal.h"
#include "sms_api.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /**********************/
 /**     CONSTANTS    **/
/**********************/

  /*********************/
 /**    TYPEDEFS     **/
/*********************/
typedef struct wsi_decoder_obj *WSI_DECODER_OBJECT;
#define WSI_DECODER_INVALID_OBJECT ((WSI_DECODER_OBJECT)NULL)

  /*****************************/
 /**    STRUCT TEMPLATES     **/
/*****************************/

// WSI Decoder Interface definition
typedef struct wsi_decoder_interface_struct
{
    /* Object Members */
    WSI_DECODER_OBJECT (*hInit)(
        SMS_OBJECT hParent,
        IMAGE_FORMAT_ENUM eFormat
            );

    // If the payload contains incorrect data the file
    // won't be create and the caller should not take care about it.
    // In success case the caller must take care about removing this file
    // once it becomes unnecessary
    BOOLEAN (*bDecodePayload)(
        WSI_DECODER_OBJECT hWsiDecoder,
        OSAL_BUFFER_HDL hPayload,
        const char *paOutputFile
            );

    // The caller must take care about removing output file in case of
    // success only. In failed case no one file will be created.
    BOOLEAN (*bGenerateRaster) (
        WSI_DECODER_OBJECT hWsiDecoder,
        const char *paDeframeFile,
        const char *paOutputFile
            );

    BOOLEAN (*bSetPlane) (
        WSI_DECODER_OBJECT hWsiDecoder,
        UN8 un8Plane
            );

    void (*vUninit)(
        WSI_DECODER_OBJECT hWsiDecoder
    );

} WSI_DECODER_INTERFACE_STRUCT;

  /****************************/
 /**     UNION TEMPLATES    **/
/****************************/

  /**********************/
 /**    VARIABLES     **/
/**********************/

extern const WSI_DECODER_INTERFACE_STRUCT GsWsiDecoderIntf;

  /*******************/
 /**    MACROS     **/
/*******************/

  /***********************/
 /**     PROTOTYPES    **/
/***********************/


#ifdef __cplusplus
}
#endif

#endif /* WSI_PLATFORM_PORT_H_ */
