/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the interface used for service-specific alerts parsers
 *
 ******************************************************************************/

/*********************************/
/** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef WS_ALERTS_INTERFACE_H_
#define WS_ALERTS_INTERFACE_H_

/**************/
/** INCLUDES **/
/**************/
#include "sms_api.h"
#include "sms_obj.h"
#include "sql_interface_obj.h"
#include "rfd_interface_obj.h"

#include "ws_alerts_mgr_obj.h"
#include "ws_alerts_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#define WS_ALERTS_SERVICE_FOLDER "ws_alerts"

#define WS_ALERTS_INTERFACE_INVALID_OBJECT (NULL)

// Localization definitions
#define WS_ALERTS_ENGLISH (0)
#define WS_ALERTS_SPANISH (1)
#define WS_ALERTS_FRENCH (2)
#define WS_ALERTS_NUM_OF_LANGS (3)

//Look up tables' IDs
#define WS_ALERTS_LUT_MSG_TYPE_CLASS_ID (0)
#define WS_ALERTS_LUT_LOCATION_CLASS_ID (1)
#define WS_ALERTS_LUT_COMMON_PHRASE_CLASS_ID (2)

#define WS_ALERTS_DTYPE_INT_MAX_BITLEN (16)

//LUT Id:  1st byte - class Id
//         2nd byte - Table Id
//         3rd byte - Language
#define WS_ALERTS_GET_LUT_ID(classId, tabId, lang) \
   (UN32)( (classId << 16) | (tabId << 8) | lang )

#define WS_ALERTS_GET_CLASS_ID_FROM_LUT_ID(lutid) \
   (UN8)( lutid >> 16 )

#define WS_ALERTS_GET_TAB_ID_FROM_LUT_ID(locid) \
    (UN8)(((locid) >> 8) & 0x00FF)

/*********************/
/** GLOBAL TYPEDEFS **/
/*********************/

// Handle to the ws alerts interface object
typedef void * WS_ALERTS_INTERFACE_OBJECT;

typedef enum ws_alerts_partition_dtype_enum
{
    WS_ALERTS_PARTITION_DTYPE_INT = 0,
    WS_ALERTS_PARTITION_DTYPE_STRING,
    WS_ALERTS_PARTITION_DTYPE_BAUDOT_STRING,
    WS_ALERTS_PARTITION_DTYPE_ARRAY_OF_INT
} WS_ALERTS_PARTITION_DTYPE_ENUM;

typedef enum ws_alerts_msg_elem_tail_enum
{
    WS_ALERTS_MSG_ELEM_TAIL_NO_SUFFIX = 0,
    WS_ALERTS_MSG_ELEM_TAIL_SPACE,
    WS_ALERTS_MSG_ELEM_TAIL_COMMA_SPACE,
    WS_ALERTS_MSG_ELEM_TAIL_PERIOD_SPACE
}WS_ALERTS_MSG_ELEMENT_TAIL_ENUM;

typedef struct ws_alerts_element_text_format_struct
{
    BOOLEAN bIsCapital;
    WS_ALERTS_MSG_ELEMENT_TAIL_ENUM eTail;
    BOOLEAN bIsBrake;
}WS_ALERTS_MSG_ELEMENT_TEXT_FORMAT_STRUCT;

typedef enum ws_alerts_element_type_enum
{
    WS_ALERTS_MSG_ELEM_TYPE_MSG_DELIMITER = 0,
    WS_ALERTS_MSG_ELEM_TYPE_START_TIME_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_END_TIME_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_GENERIC_TIME_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_POLYGON_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_TEXT_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_PHONEME_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_LARGE_CONTAINER_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_SMALL_CONTAINER_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_FILE_LINK_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_PHONE_NUMBER_ELEM,
    WS_ALERTS_MSG_ELEM_TYPE_SYSTEM_PRIORITY_ELEM
}WS_ALERTS_MSG_ELEMENT_TYPE_ENUM;

typedef struct ws_alerts_polygon_desc_struct
{
    WS_ALERT_MSG_ID tMsgId;
    size_t tLonLatArraySize;
    N32 *pn32PolygonLonLat;
    N32 n32MinLat;
    N32 n32MaxLat;
    N32 n32MinLon;
    N32 n32MaxLon;
} WS_ALERTS_POLYGON_DESC_STRUCT;

typedef struct ws_alerts_lut_desc_struct
{
    STRING_OBJECT hDecodeTableName;
    UN32 un32DecodeTableId;
    UN16 un16EntryId;
    UN16 un16EntryId2;
    UN8 un8MinVersion;
} WS_ALERTS_LUT_DESC_STRUCT;

typedef struct ws_alerts_phone_number_struct
{
    UN8 un8InternationalId;
    UN16 un16AreaCode;
    UN16 un16ExchangeCode;
    UN16 un16Number;
} WS_ALERTS_PHONE_NUMBER_STRUCT;

typedef struct ws_alerts_message_element_struct
{
    BOOLEAN bIsRegularElement;
    WS_ALERTS_MSG_ELEMENT_TEXT_FORMAT_STRUCT sTextFormat;

    union
    {
        WS_ALERTS_MSG_ELEMENT_TYPE_ENUM eType;
        WS_ALERTS_LUT_DESC_STRUCT sLutDesc;
    } uType;

    union
    {
        UN16 un16MsgSignature;
        TIME_T tEventTime;
        WS_ALERTS_POLYGON_DESC_STRUCT sPolygonDesc;
        STRING_OBJECT hText;
        WS_ALERTS_PHONE_NUMBER_STRUCT sPhoneNumber;
        UN8 un8Priority;
    } uData;

} WS_ALERTS_MGR_MESSAGE_ELEMENT_STRUCT;

typedef struct ws_alerts_msg_set_struct
{
    UN8 un8StateId;
    SMS_LANGUAGE_ENUM eLanguage;
    UN8 un8Version;
    UN8 un8Priority;
    BOOLEAN bIsHighRate;
    OSAL_OBJECT_HDL hMsgElementsList;
} WS_ALERTS_MSG_SET_DESC_STRUCT;

typedef struct ws_alerts_msg_types_entry_struct
{
    STRING_OBJECT hMsgType;
    STRING_OBJECT hText;
} WS_ALERTS_MSG_TYPES_ENTRY_STRUCT;

//Decoder typedefs
typedef struct ws_alert_msg_desc_struct
{
    // Alert index
    WS_ALERT_MSG_ID tId;
    //External reference
    OSAL_OBJECT_HDL hMsgTypesList;
    // Start time
    TIME_T tEventStartTime;
    // End time
    TIME_T tEventEndTime;
    STRING_OBJECT hMsgText;
    UN8 un8StateId;
    SMS_LANGUAGE_ENUM eMsgLang;
    OSAL_OBJECT_HDL hMsgLocationsIDs;
    UN8 un8MsgLocationsNum;
    BOOLEAN bPolygon;
    OSAL_OBJECT_HDL hPolygons;
    size_t tPriority;
    size_t tVersion;
    BOOLEAN bIsHighRate;
} WS_ALERT_MSG_DESC_STRUCT;


//RFD typedefs

typedef union ws_alerts_label_value_union
{
    UN16 un16Value;
    char *pcValue;
    STRING_OBJECT hValue;
    N32* pn32Data;
}WS_ALERTS_LABEL_VALUE_UNION;

// Structure which specifies all attributes
// of a single column in lookup table
typedef struct ws_alerts_label_desc_struct
{
    UN8 un8LabelId;
    STRING_OBJECT hLbText;
    WS_ALERTS_PARTITION_DTYPE_ENUM eDataType;
    WS_ALERTS_LABEL_VALUE_UNION uCurLbValue;
    size_t tCurrentArrayNum;
    BOOLEAN bPresence;
} WS_ALERTS_LABEL_DESC_STRUCT;

// Structure which specifies all attributes
// of a single partition
typedef struct ws_alerts_parition_desc_struct
{
    //Name of Look Up table to update
    STRING_OBJECT hLutName;
    UN8 un8ClassId;
    UN8 un8TableId;
    UN16 un16UpdateVersion; // Partition update version
    UN8 un8NumOfLabels;
    OSAL_OBJECT_HDL hLabelsList; //list of WS_ALERTS_LABEL_DESC_STRUCT
} WS_ALERTS_LUT_UPDATE_DESC_STRUCT;


/*****************************/
/** GLOBAL STRUCT TEMPLATES **/
/*****************************/

typedef struct ws_alerts_plugin_interface_struct
{
    const DSI tDSI;

    const size_t tMaxVersionBitlen;

    size_t (*tMinimumOTABufferByteSize) (
        BOOLEAN bDBUpdatesEnabled
            );

    // Returns a handle to an object that contains
    // broadcast specific data used for parsing the traffic
    // data stream
    WS_ALERTS_INTERFACE_OBJECT (*hInit) (
        WS_ALERTS_SERVICE_OBJECT hAlertsService,
        SMS_OBJECT hParent,
        SQL_INTERFACE_OBJECT hSQLRefConnection,
        RFD_UPDATE_VERSION tCurrentVersion,
        BOOLEAN bDBUpdatesEnabled
            );

    BOOLEAN (*bProcessMessage) (
        WS_ALERTS_INTERFACE_OBJECT hInterface,
        OSAL_BUFFER_HDL *phPayload
            );

    // Removes any resources that was created to aid in
    void (*vUnInit) (
        WS_ALERTS_INTERFACE_OBJECT hInterface
            );

} WS_ALERTS_PLUGIN_INTERFACE_STRUCT;

// The alerts manager's interface APIs
typedef struct ws_alerts_mgr_interface_struct
{
    BOOLEAN (*bConstructMessages) (
        WS_ALERTS_SERVICE_OBJECT hAlertsService,
        WS_ALERTS_MSG_SET_DESC_STRUCT *psMsgSetDesc,
        BOOLEAN bRemoveMsgsFromDB
            );

    BOOLEAN (*bDBUpdateBegin) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize
            );

    BOOLEAN (*bDBUpdateEnd) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        RFD_UPDATE_VERSION tUpdateVersion
            );

    BOOLEAN (*bRefDBBank) (
        WS_ALERTS_SERVICE_OBJECT hWsAlertsService,
        STRING_OBJECT *phInUseDB,
        STRING_OBJECT *phNextDB
            );

    void (*vTooOldDBVer) (
        WS_ALERTS_SERVICE_OBJECT hWSAlertsService
            );

    void (*vStateUpdateCompleted) (
        WS_ALERTS_SERVICE_OBJECT hAlertsService
            );

    BOOLEAN (*bDeleteRow) (
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc
            );

    BOOLEAN (*bUpdateRow)(
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc
            );

    BOOLEAN (*bGetCurrentDbVersion)(
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        STRING_OBJECT hLutName,
        N32 *pn32DBVer
            );

    BOOLEAN (*bCheckLutTable)(
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc
            );

    BOOLEAN (*bCheckRowExist)(
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc,
        BOOLEAN *bExist
            );

    BOOLEAN (*bInsertRow)(
        SQL_INTERFACE_OBJECT hConnection,
        char *pacBuffer,
        size_t tBufferSize,
        WS_ALERTS_LUT_UPDATE_DESC_STRUCT *psLutUpdateDesc
            );

} WS_ALERTS_MGR_INTERFACE_STRUCT;

/****************************/
/** GLOBAL UNION TEMPLATES **/
/****************************/

/**********************/
/** GLOBAL VARIABLES **/
/**********************/
// Interface into the Alerts plugins
extern const WS_ALERTS_PLUGIN_INTERFACE_STRUCT GsWSAlertsIntf;

// Interface into the Alerts Manager
extern const WS_ALERTS_MGR_INTERFACE_STRUCT GsWSAlertsMgrIntf;


/*******************/
/** GLOBAL MACROS **/
/*******************/

/***********************/
/** GLOBAL PROTOTYPES **/
/***********************/

#endif /* WS_ALERTS_INTERFACE_H_ */
