/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:WEATHER_MSG header file.
 *
 ******************************************************************************/

#ifndef WEATHER_MSG_OBJ_H_
#define WEATHER_MSG_OBJ_H_


#include "location_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/


  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/


  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

WEATHER_MSG_OBJECT WEATHER_MSG_hCreate(
    SMS_OBJECT hParent,
    size_t tDSRLEntryDescSize,
    LOCATION_OBJECT hLocation,
    STRING_OBJECT hICAO,
    WEATHER_MSG_OBJECT_TYPE_ENUM eType
        );

void WEATHER_MSG_vDestroy (
    WEATHER_MSG_OBJECT hWeatherMsg
        );

BOOLEAN WEATHER_MSG_bSetForecast (
    WEATHER_MSG_OBJECT hWeatherMsg,
    WEATHER_FORECAST_TYPE_ENUM eForecastType,
    FORECAST_OBJECT hForecast
        );

BOOLEAN WEATHER_MSG_bSetSkiCond (
    WEATHER_MSG_OBJECT hWeatherMsg,
    SKI_CONDITIONS_OBJECT hSkiCond
        );

BOOLEAN WEATHER_MSG_bSetLocation (
    WEATHER_MSG_OBJECT hWeatherMsg,
    LOCATION_OBJECT hLocation,
    STRING_OBJECT hICAO
        );

LOC_ID WEATHER_MSG_tGetLOCID(
    WEATHER_MSG_OBJECT hWeatherMsg
        );

WEATHER_MSG_OBJECT WEATHER_MSG_hCreateDummy(
    SMS_OBJECT hParent,
    LOCATION_OBJECT hLocation
        );

#endif /* WEATHER_MSG_OBJ_H_ */
