/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SPORTS_FLASH header file.
 *
 ******************************************************************************/

#ifndef TW_NOW_OBJ_H_
#define TW_NOW_OBJ_H_

#include "sms_api.h"

/**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct tw_now_object * TW_NOW_OBJECT;
#define TW_NOW_INVALID_OBJECT (TW_NOW_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN TW_NOW_bDecoderEventHandler (
    DECODER_OBJECT hDecoder,
    TW_NOW_OBJECT hTWNow,
    const SMS_EVENT_TW_NOW_STRUCT *psEventData
        );

BOOLEAN TW_NOW_bHandleBulletinEvent (
    DECODER_OBJECT hDecoder,
    TW_NOW_BULLETIN_ID tBulletinID,
    TW_NOW_BULLETIN_STATUS_ENUM eBulletinStatus,
    TRAFFIC_MARKET tMarketID
        );

void TW_NOW_vUpdateStatus(
    TW_NOW_OBJECT hTWNow,
    TW_NOW_BULLETIN_ID tBulletinId,
    BOOLEAN *pbIsActive,
    BOOLEAN *pbChanged
        );

void TW_NOW_vStop (
    TW_NOW_OBJECT hTWNow
        );

#endif /* TWN_OBJ_H_ */
