/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:TRAFFIC_MSG_BASE header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef TRAFFIC_MSG_BASE_H_
#define TRAFFIC_MSG_BASE_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

typedef struct traffic_msg_base_object * TRAFFIC_MSG_BASE_OBJECT;
#define TRAFFIC_MSG_BASE_INVALID_OBJECT (TRAFFIC_MSG_BASE_OBJECT)NULL

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct traffic_msg_base_object_interface_struct
{
    TRAFFIC_MSG_TYPE_ENUM (*eType) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    TRAFFIC_MSG_CLASS_ENUM (*eClass) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    TRAFFIC_SPEED_ENUM (*eSpeed) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    TRAFFIC_DURATION_ENUM (*eDuration) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    TRAFFIC_DIRECTION_ENUM (*eDirection) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    BOOLEAN (*bDiversionAdvised) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    TRAFFIC_EVENT_CODE (*tEventCode) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    STRING_OBJECT (*hText) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    STRING_OBJECT (*hAdditionalText) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    UN32 (*un32StartTime) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    UN32 (*un32StopTime) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    UN8 (*un8GetFreeFormData) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg,
        ALERTC_FREEFORM_DATA_LABEL_ENUM eLabel,
        UN16 *paun16Values,
        size_t tCount
            );

    UN8 (*un8NumLocations) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

    LOCATION_OBJECT (*hGetLocation) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg,
        UN8 un8Index
            );

    N32 (*n32FPrintf) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg,
        FILE *psFile,
        SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
            );

    SMSAPI_RETURN_CODE_ENUM  (*eIterateLocations) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg,
        TRAFFIC_MSG_LOCATION_ITERATOR bIterator,
        void *pvIteratorArg
            );

    SMSAPI_RETURN_CODE_ENUM (*eCameraDirection) (
        TRAFFIC_MSG_BASE_OBJECT hTrafficMsg,
        UN16 *pun16Direction
            );

    IMAGE_OBJECT (*hImage) (
       TRAFFIC_MSG_BASE_OBJECT hTrafficMsg
            );

} TRAFFIC_MSG_BASE_OBJECT_INTERFACE_STRUCT;

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

TRAFFIC_MSG_OBJECT TRAFFIC_MSG_BASE_hCreate(
    void **ppvData,
    const char *pacName,
    SMS_OBJECT hParent,
    size_t tObjectDataSize,
    size_t tServiceDataSize,
    const TRAFFIC_MSG_BASE_OBJECT_INTERFACE_STRUCT *psIntf
        );

void TRAFFIC_MSG_BASE_vDestroy(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

void *TRAFFIC_MSG_BASE_pvObjectData(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

#endif /* TRAFFIC_MSG_BASE_H_ */
