/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Traffic Cameras Interface header file.
 *
 ******************************************************************************/

#ifndef TRAFCAM_INTERFACE_H_
#define TRAFCAM_INTERFACE_H_

#include "standard.h"
#include "osal.h"
#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Interface handle
typedef void * TRAFCAM_INTERFACE_OBJECT;
#define TRAFCAM_INTERFACE_INVALID_OBJECT \
            (TRAFCAM_INTERFACE_OBJECT)NULL

#define TRAFCAM_INVALID_DIRECTION (UN16_MAX)

typedef void * TRAFCAM_IMAGE_HASH;
#define TRAFCAM_IMAGE_INVALID_HASH \
    (TRAFCAM_IMAGE_HASH)NULL

typedef enum trafcam_location_type_enum
{
    TRAFCAM_LOCATION_TYPE_TMC,
    TRAFCAM_LOCATION_TYPE_GEO
} TRAFCAM_LOCATION_TYPE_ENUM;

typedef struct trafcam_bsa_filter_struct
{
    TRAFFIC_MARKET tMarket;
    TRAFFIC_BSA tBSA;
    OSAL_OBJECT_HDL hDSRLList;
    OSAL_LINKED_LIST_ENTRY hEntry;
} TRAFCAM_BSA_FILTER_STRUCT;

typedef struct trafcam_image_info_struct
{
    TRAFFIC_MARKET tMarket;
    TRAFFIC_BSA tBSA;

    OSAL_FIXED_OBJECT hLat;
    OSAL_FIXED_OBJECT hLon;
    OSAL_FIXED_OBJECT_DATA atFixedData[OSAL_FIXED_OBJECT_SIZE * 2];

    TRAFFIC_POS_CODE tPosCode;
    TRAFFIC_OFFSET tOffset;

    UN16 un16Direction;
    STRING_OBJECT hDescription;
    UN32 un32ProcessTimeStamp;
    TRAFCAM_IMAGE_HASH tHash;
    UN16 un16TTL;

} TRAFCAM_IMAGE_INFO_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/
// The Traffic Camera interface APIs
typedef struct trafcam_plugin_interface_struct
{
    const size_t tOTABufferByteSize;

    const DSI tDSI;

    TRAFCAM_INTERFACE_OBJECT (*hInit) (
        TRAFFIC_CAMERAS_SERVICE_OBJECT hTrafficCamerasService,
        SMS_OBJECT hParent
            );

    void (*vUnInit) (
        TRAFCAM_INTERFACE_OBJECT hInterface
            );

    BOOLEAN (*bProcessMessage) (
        TRAFCAM_INTERFACE_OBJECT hInterface,
        OSAL_BUFFER_HDL *phPayload
            );

    BOOLEAN (*bSetFilter) (
        TRAFCAM_INTERFACE_OBJECT hInterface,
        OSAL_OBJECT_HDL hFilter
            );

    BOOLEAN (*bReportExpiredHash) (
        TRAFCAM_INTERFACE_OBJECT hInterface,
        TRAFCAM_IMAGE_HASH tHash
            );

} TRAFCAM_PLUGIN_INTERFACE_STRUCT;

typedef struct trafcam_mgr_interface_struct
{
    BOOLEAN (*bReportNewImage) (
        TRAFFIC_CAMERAS_SERVICE_OBJECT hTrafficCameras,
        TRAFCAM_IMAGE_INFO_STRUCT *psImageInfo,
        OSAL_BUFFER_HDL hImageBuffer
            );

    BOOLEAN (*bReportUpdatedImage) (
        TRAFFIC_CAMERAS_SERVICE_OBJECT hTrafficCameras,
        TRAFCAM_IMAGE_HASH tHash,
        OSAL_BUFFER_HDL hImageBuffer
            );

    BOOLEAN (*bReportRepeatedImage) (
        TRAFFIC_CAMERAS_SERVICE_OBJECT hTrafficCameras,
        TRAFCAM_IMAGE_HASH tHash
            );

    BOOLEAN (*bReportRemovedImage) (
        TRAFFIC_CAMERAS_SERVICE_OBJECT hTrafficCameras,
        TRAFCAM_IMAGE_HASH tHash
            );
} TRAFCAM_MGR_INTERFACE_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// Interface into the Traffic Cameras plugins
extern const TRAFCAM_PLUGIN_INTERFACE_STRUCT GsTrafcamIntf;

// Interface into the Traffic Cameras Manager
extern const TRAFCAM_MGR_INTERFACE_STRUCT GsTrafcamMgr;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

#endif /* TRAFCAM_INTERFACE_H_ */

