/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/

/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the constants used when utilizing the Traffic Cameras
 * database file
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef TRAFCAM_DB_CONSTANTS_H_
#define TRAFCAM_DB_CONSTANTS_H_


  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"


  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

/* Database File Name */
#define TRAFCAM_DATABASE_FOLDER "trafcam"
#define TRAFCAM_REF_DATABASE_FILENAME "trafcam_ref.db"

/* Database Table Attributes */
#define TRAFCAM_DATABASE_FILE_VERSION (1)

/* Database Table Names */
#define VERSION_TABLE_NAME "version"
#define TABLES_TABLE_NAME "tables"
#define BSAS_TABLE_NAME "bsas"
#define BSAS_RTREE_TABLE_NAME "bsas_rtree"

/*  set fixed_constant [expr 1 << $binpoint]
    set rtree_range [expr .000015 * $fixed_constant] */
#define TRAFCAM_RTREE_RANGE      ((N32)62)

#define TRAFCAM_MAX_SQL_STRING_LENGTH (2000)

/* Database Queries */

// Select traffic camera DB schema version
#define TRAFCAM_SELECT_DB_SCHEMA_VERSION \
    "select version from "VERSION_TABLE_NAME" where type=0;"

// Select traffic camera DB data version
#define TRAFCAM_SELECT_DB_DATA_VERSION \
    "select version from "VERSION_TABLE_NAME" where type=1;"

// Select BSAs by coordinates
#define TRAFCAM_SELECT_BSAS_BY_COORDINATES \
    "select table_id, location from "BSAS_TABLE_NAME" where gen_bsa_id in " \
    "(select gen_bsa_id from "BSAS_RTREE_TABLE_NAME" where " \
    "("BSAS_RTREE_TABLE_NAME".lat_min >= %d and " \
    BSAS_RTREE_TABLE_NAME".lat_min <= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_min >= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_min <= %d) or " \
    "("BSAS_RTREE_TABLE_NAME".lat_min >= %d and " \
    BSAS_RTREE_TABLE_NAME".lat_min <= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_max >= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_max <= %d) or " \
    "("BSAS_RTREE_TABLE_NAME".lat_max >= %d and " \
    BSAS_RTREE_TABLE_NAME".lat_max <= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_max >= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_max <= %d) or " \
    "("BSAS_RTREE_TABLE_NAME".lat_max >= %d and " \
    BSAS_RTREE_TABLE_NAME".lat_max <= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_min >= %d and " \
    BSAS_RTREE_TABLE_NAME".lon_min <= %d) or " \
    "(%d >= "BSAS_RTREE_TABLE_NAME".lat_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lat_max and " \
    "%d >= "BSAS_RTREE_TABLE_NAME".lon_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lon_max) or " \
    "(%d >= "BSAS_RTREE_TABLE_NAME".lat_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lat_max and " \
    "%d >= "BSAS_RTREE_TABLE_NAME".lon_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lon_max) or " \
    "(%d >= "BSAS_RTREE_TABLE_NAME".lat_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lat_max and " \
    "%d >= "BSAS_RTREE_TABLE_NAME".lon_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lon_max) or " \
    "(%d >= "BSAS_RTREE_TABLE_NAME".lat_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lat_max and " \
    "%d >= "BSAS_RTREE_TABLE_NAME".lon_min and " \
    "%d <= "BSAS_RTREE_TABLE_NAME".lon_max)) order by table_id, location;"


#define TRAFCAM_SELECT_BSAS_BY_MARKET \
    "select table_id, location from "BSAS_TABLE_NAME" where table_id=%u;"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef enum trafcam_db_version_type_enum {
    TRAFCAM_DB_VERSION_TYPE_SCHEMA = 0,
    TRAFCAM_DB_VERSION_TYPE_DATA
} TRAFCAM_DB_VERSION_TYPE_ENUM;

// Enumeration specifying all the required fields
// in the version table
typedef enum trafcam_db_version_fields_enum {
    TRAFCAM_DB_VERSION_FIELD_VERSION,
    TRAFCAM_DB_VERSION_MAX_FIELDS
} TRAFCAM_DB_VERSION_FIELDS_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

// Structure which specifies all attributes
// of a single database version row that is
// available within the Traffic Camera database
// These are the raw values that are retrieved from the database
typedef struct trafcam_db_version_row_struct
{
    UN8 un8Type;
    UN32 un32Version;
} TRAFCAM_DB_VERSION_ROW_STRUCT;

typedef struct trafcam_bsa_row_struct
{
    UN32 un32Market;
    UN32 un32BSA;
} TRAFCAM_BSA_ROW_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

// Union to group all the row definitions
// in a convenient manner
typedef union trafcam_db_row_union
{
    TRAFCAM_DB_VERSION_ROW_STRUCT *psVersion;
    TRAFCAM_BSA_ROW_STRUCT *psBSA;
} TRAFCAM_DB_ROW_UNION;


  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* TRAFCAM_DB_CONSTANTS_H_ */
