/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 ******************************************************************************/

#ifndef THEATER_TIMES_OBJ_H_
#define THEATER_TIMES_OBJ_H_

#include "sms_api.h"
#include "movies_db_constants.h"
#include "sql_interface_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct theater_times_object * THEATER_TIMES_OBJECT;
#define THEATER_TIMES_INVALID_OBJECT (THEATER_TIMES_OBJECT)NULL

typedef struct theater_times_movie_entry_object * THEATER_TIMES_MOVIE_ENTRY_OBJECT;
#define THEATER_TIMES_MOVIE_ENTRY_INVALID_OBJECT (THEATER_TIMES_MOVIE_ENTRY_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
THEATER_TIMES_OBJECT THEATER_TIMES_hCreate (
    MOVIES_SERVICE_OBJECT hMoviesService,
    SMS_OBJECT hParent,
    THEATER_ID tID,
    UN32 un32InitialTime,
    UN8 un8NumMovies
        );

THEATER_TIMES_OBJECT THEATER_TIMES_hCreateFromDB (
    MOVIES_SERVICE_OBJECT hMoviesService,
    SMS_OBJECT hParent,
    THEATER_TIMES_ROW_STRUCT *psTimesRow
        );

BOOLEAN THEATER_TIMES_bReuse (
    THEATER_TIMES_OBJECT hTheaterTimes,
    THEATER_ID tID,
    UN32 un32InitialTime,
    UN8 un8NumMovies
        );

UN8 THEATER_TIMES_un8NumMovies (
    THEATER_TIMES_OBJECT hTheaterTimes
        );

THEATER_TIMES_MOVIE_ENTRY_OBJECT THEATER_TIMES_hAddMovie (
    THEATER_TIMES_OBJECT hTheaterTimes,
    MOVIE_ID tID,
    MOVIE_RATING_SYS_CODE tRatingExceptionSystem,
    MOVIE_RATING_CODE tRatingException
        );

BOOLEAN THEATER_TIMES_bAddShowTimeOffset (
    THEATER_TIMES_OBJECT hTheaterTimes,
    THEATER_TIMES_MOVIE_ENTRY_OBJECT hMovieEntry,
    UN16 un16ShowTimeOffset
        );

SMSAPI_RETURN_CODE_ENUM THEATER_TIMES_eIterateMovies (
    THEATER_TIMES_OBJECT hTheaterTimes,
    THEATER_OBJECT hTheater,
    THEATER_MOVIES_ITERATOR bIterator,
    void *pvIteratorArg
        );

SMSAPI_RETURN_CODE_ENUM THEATER_TIMES_eIterateTimes (
    THEATER_TIMES_OBJECT hTheaterTimes,
    THEATER_OBJECT hTheater,
    THEATER_MOVIE_TIMES_ITERATOR bIterator,
    void *pvIteratorArg
        );

BOOLEAN THEATER_TIMES_bInsertIntoDB (
    THEATER_TIMES_OBJECT hTheaterTimes,
    SQL_INTERFACE_OBJECT hSQL,
    SQL_PREPARED_STATEMENT_HANDLE hStmt,
    SQL_BIND_PARAMETER_STRUCT *psBindParams,
    UN16 *pun16BlobData,
    size_t tBlobDataSize
        );

void THEATER_TIMES_vDestroy (
    THEATER_TIMES_OBJECT hTheaterTimes
        );

#endif /* THEATER_TIMES_OBJ_H_ */
