/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:Tag header file.
 *
 ******************************************************************************/

#ifndef TAG_OBJ_H_
#define TAG_OBJ_H_

#include "standard.h"
#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct tag_object * TAG_OBJECT;
#define TAG_INVALID_OBJECT (TAG_OBJECT)NULL

typedef enum tag_type_enum
{
    TAG_TYPE_STRING,
    TAG_TYPE_INTEGER,
    TAG_TYPE_BINARY,
    TAG_TYPE_INVALID
} TAG_TYPE_ENUM;

typedef BOOLEAN (*TAG_ITERATION_HANDLER)(
    TAG_OBJECT hTag,
    void *pvArg
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
SMSAPI_RETURN_CODE_ENUM TAG_eAdd(
    const char *pacName,
    TAG_OBJECT hParentTag,
    TAG_OBJECT *phNewTag,
    const char *pacIdentifier
        );

SMSAPI_RETURN_CODE_ENUM TAG_eGet(
    const char *pacName,
	TAG_OBJECT hParentTag,
	TAG_OBJECT *phTag,
	const char *pacIdentifier,
    BOOLEAN bAddIfNotFound
        );

SMSAPI_RETURN_CODE_ENUM TAG_eRemove(
    TAG_OBJECT hTag,
    BOOLEAN bImmediateCommit
        );

SMSAPI_RETURN_CODE_ENUM TAG_eIterateChildren(
    TAG_OBJECT hParentTag,
    TAG_ITERATION_HANDLER bIterator,
    void *pvArg
        );

SMSAPI_RETURN_CODE_ENUM TAG_eNumberOfChildren (
    TAG_OBJECT hParentTag,
    UN32 *pun32NumberOfChildren
        );

SMSAPI_RETURN_CODE_ENUM TAG_eFirstChild(
    TAG_OBJECT hParentTag,
    TAG_OBJECT *phFirstChildTag
        );

SMSAPI_RETURN_CODE_ENUM TAG_eNextSibling(
    TAG_OBJECT hTag,
    TAG_OBJECT *phNextSiblingTag
        );

SMSAPI_RETURN_CODE_ENUM TAG_ePreviousSibling(
    TAG_OBJECT hTag,
    TAG_OBJECT *phPreviousSiblingTag
        );

STRING_OBJECT TAG_hTagName(
    TAG_OBJECT hTag
        );

STRING_OBJECT TAG_hTagInstanceName(
    TAG_OBJECT hTag
        );

SMSAPI_RETURN_CODE_ENUM TAG_eSetTagValue(
    TAG_OBJECT hTag,
    TAG_TYPE_ENUM eTagType,
    void *pvTagValue,
    size_t tNumBytes,
    BOOLEAN bImmediateCommit
        );

SMSAPI_RETURN_CODE_ENUM TAG_eGetTagValue(
    TAG_OBJECT hTag,
    TAG_TYPE_ENUM eTagType,
    void **pvTagValue,
    size_t *ptNumAvailableBytes
        );

#endif /* TAG_OBJ_H */
