/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the constants used when utilizing the stock ticker
 * database file
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef STOCK_TICKER_DB_CONSTANTS_H_
#define STOCK_TICKER_DB_CONSTANTS_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"


  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

/* Database File Name */
#define STOCK_TICKER_DATABASE_FOLDER "stock_ticker"
#define STOCK_TICKER_REF_DATABASE_FILENAME STOCK_TICKER_DATABASE_FOLDER"_ref.db"

/* Database Table Names */
#define STOCK_TICKER_DATABASE_VERSION_TABLE_NAME "db_version"
#define STOCK_TICKER_STOCK_SYMBOL_TABLE_NAME "stock_symbol"
#define STOCK_TICKER_MSG_HASH_TABLE_NAME "msg_hash"
#define STOCK_TICKER_PROVIDER_DATA_TABLE_NAME "provider_data"
#define STOCK_TICKER_DATA_VERSION_TABLE_NAME "data_version"

/* Database fields */
#define STOCK_TICKER_SYMBOL_TABLE_FLD_INDEX_NAME "sym_index"
#define STOCK_TICKER_SYMBOL_TABLE_FLD_NAME_NAME "sym_name"
#define STOCK_TICKER_HASH_TABLE_FLD_ID_NAME "id"
#define STOCK_TICKER_HASH_TABLE_FLD_TYPE_NAME "msg_type"
#define STOCK_TICKER_HASH_TABLE_FLD_HASH_NAME "hash"
#define STOCK_TICKER_PD_TABLE_FLD_SEQID_NAME "seq_id"
#define STOCK_TICKER_PD_TABLE_FLD_INFO_NAME "info"
#define STOCK_TICKER_DATA_VERSION_TABLE_FLD_VERSION_NAME "version"

/* Database utility consts */
#define STOCK_TICKER_PATTERN_SIGN "%"

/* Database Table Attributes */
#define STOCK_TICKER_DATABASE_FILE_VERSION (1)

/* Database Queries */

// Select all from version
#define STOCK_TICKER_SELECT_DB_VERSION \
    "select * from "STOCK_TICKER_DATABASE_VERSION_TABLE_NAME";"

// Select all symbols with their names
#define STOCK_TICKER_SELECT_DB_ALL_SYMBOLS \
    "select * from "STOCK_TICKER_STOCK_SYMBOL_TABLE_NAME" "\
        "order by "STOCK_TICKER_SYMBOL_TABLE_FLD_NAME_NAME";"

// Select all symbol by its id
#define STOCK_SELECT_SYMBOL_STMT_INDEX_PARAM    0
#define STOCK_SELECT_SYMBOL_STMT_PARAMS_COUNT   1

#define STOCK_TICKER_SELECT_DB_SYMBOL_BY_ID \
    "select "STOCK_TICKER_SYMBOL_TABLE_FLD_NAME_NAME" " \
            "from "STOCK_TICKER_STOCK_SYMBOL_TABLE_NAME" " \
            "where "STOCK_TICKER_SYMBOL_TABLE_FLD_INDEX_NAME"=?;"
#define STOCK_TICKER_SELECT_DB_SYMBOL_BY_ID_COLUMN_SIZE (1)

// Select all symbol by its name
#define STOCK_TICKER_SELECT_DB_SYMBOL_BY_NAME \
    "select "STOCK_TICKER_SYMBOL_TABLE_FLD_INDEX_NAME" " \
            "from "STOCK_TICKER_STOCK_SYMBOL_TABLE_NAME" " \
            "where "STOCK_TICKER_SYMBOL_TABLE_FLD_NAME_NAME"=\"%s\";"
#define STOCK_TICKER_SELECT_DB_SYMBOL_BY_NAME_COLUMN_SIZE (1)

// Insert new symbol
#define STOCK_INSERT_SYMBOL_STMT_INDEX_PARAM    0
#define STOCK_INSERT_SYMBOL_STMT_NAME_PARAM     1
#define STOCK_INSERT_SYMBOL_STMT_PARAMS_COUNT   2

#define STOCK_TICKER_INSERT_DB_SYMBOL \
    "insert into "STOCK_TICKER_STOCK_SYMBOL_TABLE_NAME" (" \
            STOCK_TICKER_SYMBOL_TABLE_FLD_INDEX_NAME"," \
            STOCK_TICKER_SYMBOL_TABLE_FLD_NAME_NAME") " \
            "values (?, ?);"

// Update existing symbol
#define STOCK_UPDATE_SYMBOL_STMT_NAME_PARAM     0
#define STOCK_UPDATE_SYMBOL_STMT_INDEX_PARAM    1
#define STOCK_UPDATE_SYMBOL_STMT_PARAMS_COUNT   2

#define STOCK_TICKER_UPDATE_DB_SYMBOL \
    "update "STOCK_TICKER_STOCK_SYMBOL_TABLE_NAME" " \
            "set "STOCK_TICKER_SYMBOL_TABLE_FLD_NAME_NAME"=? " \
            "where "STOCK_TICKER_SYMBOL_TABLE_FLD_INDEX_NAME"=?;"

// Select all caches from the table
#define STOCK_TICKER_SELECT_DB_ALL_HASH \
    "select * from "STOCK_TICKER_MSG_HASH_TABLE_NAME";"

// Insert new hash
#define STOCK_TICKER_INSERT_DB_MSG_HASH \
    "insert into "STOCK_TICKER_MSG_HASH_TABLE_NAME" (" \
            STOCK_TICKER_HASH_TABLE_FLD_ID_NAME"," \
            STOCK_TICKER_HASH_TABLE_FLD_TYPE_NAME","\
            STOCK_TICKER_HASH_TABLE_FLD_HASH_NAME") " \
            "values (?, ?, ?);"

// Update old hash record by new value
#define STOCK_TICKER_UPDATE_INSTEAD_OF_OLD_DB_MSG_HASH \
    "update "STOCK_TICKER_MSG_HASH_TABLE_NAME" " \
            "set "STOCK_TICKER_HASH_TABLE_FLD_ID_NAME"=?,"  \
                  STOCK_TICKER_HASH_TABLE_FLD_TYPE_NAME"=?," \
                  STOCK_TICKER_HASH_TABLE_FLD_HASH_NAME"=? " \
            "where "STOCK_TICKER_HASH_TABLE_FLD_ID_NAME"=%d;"

// Select all data provider information fields
#define STOCK_TICKER_SELECT_DB_DP_ALL \
    "select * from "STOCK_TICKER_PROVIDER_DATA_TABLE_NAME";"

// Insert new provider data
#define STOCK_TICKER_INSERT_DB_DP \
    "insert into "STOCK_TICKER_PROVIDER_DATA_TABLE_NAME" (" \
            STOCK_TICKER_PD_TABLE_FLD_SEQID_NAME"," \
            STOCK_TICKER_PD_TABLE_FLD_INFO_NAME") " \
            "values (?, ?)"

// Update old hash record by new value
#define STOCK_TICKER_UPDATE_INSTEAD_OF_OLD \
    "update "STOCK_TICKER_PROVIDER_DATA_TABLE_NAME" " \
            "set "STOCK_TICKER_PD_TABLE_FLD_SEQID_NAME"=?,"  \
                  STOCK_TICKER_PD_TABLE_FLD_INFO_NAME"=?" \
            "where "STOCK_TICKER_PD_TABLE_FLD_SEQID_NAME"=%d;"

// Select all from version
#define STOCK_TICKER_SELECT_DATA_VERSION \
    "select * from "STOCK_TICKER_DATA_VERSION_TABLE_NAME";"

#define STOCK_TICKER_UPDATE_DATA_VERSION \
    "update "STOCK_TICKER_DATA_VERSION_TABLE_NAME" set " \
        STOCK_TICKER_DATA_VERSION_TABLE_FLD_VERSION_NAME"=max(1," \
        STOCK_TICKER_DATA_VERSION_TABLE_NAME"."STOCK_TICKER_DATA_VERSION_TABLE_FLD_VERSION_NAME"+1);"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
// Enumeration specifying all the available fields
// in the db_version table
typedef enum stock_ticker_db_version_fields_enum {
    STOCK_TICKER_DB_VERSION_FIELD_DSI = 0,
    STOCK_TICKER_DB_VERSION_FIELD_DB_VER = 1,
    STOCK_TICKER_DB_VERSION_MAX_FIELDS
} STOCK_TICKER_DB_VERSION_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the stock symbol table
typedef enum stock_ticker_db_stock_symbol_fields_enum {
    STOCK_TICKER_DB_STOCK_SYMBOL_FIELD_INDEX = 0,
    STOCK_TICKER_DB_STOCK_SYMBOL_FIELD_NAME = 1,
    STOCK_TICKER_DB_STOCK_SYMBOL_MAX_FIELDS
} STOCK_TICKER_DB_STOCK_SYMBOL_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the stock symbol table in case of update
typedef enum stock_ticker_db_stock_symbol_update_fields_enum {
    STOCK_TICKER_DB_STOCK_SYMBOL_UPDATE_FIELD_NAME = 0,
    STOCK_TICKER_DB_STOCK_SYMBOL_UPDATE_FIELD_INDEX = 1,
    STOCK_TICKER_DB_STOCK_SYMBOL_UPDATE_MAX_FIELDS
} STOCK_TICKER_DB_STOCK_SYMBOL_UPDATE_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the msg_hash table
typedef enum stock_ticker_db_msg_hash_fields_enum {
    STOCK_TICKER_DB_MSG_HASH_FIELD_ID = 0,
    STOCK_TICKER_DB_MSG_HASH_FIELD_TYPE = 1,
    STOCK_TICKER_DB_MSG_HASH_FIELD_HASH = 2,
    STOCK_TICKER_DB_MSG_HASH_MAX_FIELDS
} STOCK_TICKER_MSG_HASH_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the msg_hash table
typedef enum stock_ticker_db_dp_info_fields_enum {
    STOCK_TICKER_DB_DP_INFO_FIELD_SEQID = 0,
    STOCK_TICKER_DB_DP_INFO_FIELD_INFO = 1,
    STOCK_TICKER_DB_DP_INFO_MAX_FIELDS
} STOCK_TICKER_MSG_DP_INFO_FIELDS_ENUM;

// Enumeration specifying all the available fields
// in the data version table
typedef enum stock_ticker_data_version_fields_enum {
    STOCK_TICKER_DATA_VERSION_FIELD_VERSION = 0,
    STOCK_TICKER_DATA_VERSION_MAX_FIELDS
} STOCK_TICKER_DATA_VERSION_FIELDS_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/
// Structure which specifies all attributes
// of a single database version row that is
// available within the weather database
// These are the raw values that are retrieved from the database
typedef struct stock_ticker_version_row_struct
{
    // Database schema version
    UN8 un8DBVer;
    // DSI
    DSI tDSI;
} STOCK_TICKER_VERSION_ROW_STRUCT;

// Structure which specifies all attributes
// of a single symbol row
typedef struct stock_ticker_symbol_row_struct
{
    // Index
    STOCK_ID tIndex;
    // Name
    STRING_OBJECT hName;
} STOCK_TICKER_SYMBOL_ROW_STRUCT;

// Structure which specifies all attributes
// of a single data provider info row
typedef struct stock_ticker_data_provoder_info_row_struct
{
    // Sequence Number
    UN8 un8SeqNumber;
    // Info
    STRING_OBJECT hInfo;
} STOCK_TICKER_DATA_PROVIDER_INFO_ROW_STRUCT;

// Stock Ticker Data Version Struct
typedef struct stock_ticker_data_version_row_struct
{
    UN32 un32Version;
} STOCK_TICKER_DATA_VERSION_ROW_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/
// Union to group all the row definitions
// in a convenient manner
typedef union stock_ticker_db_row_union
{
    STOCK_TICKER_VERSION_ROW_STRUCT sVersion;
    STOCK_TICKER_SYMBOL_ROW_STRUCT sSymbol;
    STOCK_TICKER_DATA_PROVIDER_INFO_ROW_STRUCT sDataProviderInfo;
    STOCK_TICKER_DATA_VERSION_ROW_STRUCT sDataVersion;
} STOCK_TICKER_DB_ROW_UNION;

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* STOCK_TICKER_DB_CONSTANTS_H_ */
