/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS Task header file.
 *
 ******************************************************************************/

#ifndef SRM_OBJ_H_
#define SRM_OBJ_H_

#include "standard.h"

#include "sms_api.h"
#include "sms_event.h"
#include "tag_obj.h"
#include "radio.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN SRM_bRelease (
    SRM_OBJECT hSRM,
    SMS_OBJECT_RELEASE_INITIATOR_ENUM eInitiator
        );

SRM_STATE_ENUM SRM_eState (
    SRM_OBJECT hSRM
        );

BOOLEAN SRM_bAddModule (
    SRM_OBJECT hSRM,
    MODULE_OBJECT hModule,
    MODULE_ID tId
        );

BOOLEAN SRM_bRemoveModule (
    SRM_OBJECT hSRM,
    MODULE_OBJECT hModule
        );

BOOLEAN SRM_bSetError (
    SRM_OBJECT hSRM,
    SRM_ERROR_CODE_ENUM eErrorCode
        );

BOOLEAN SRM_bPostRadioEvent (
    SRM_OBJECT hSRM,
    SMS_EVENT_TYPE_ENUM eEvent,
    void *pvArg
        );

MODULE_OBJECT SRM_hModule (
    SRM_OBJECT hSRM,
    MODULE_ID tId
        );

const char *SRM_pacDriverName (
    SRM_OBJECT hSRM
        );

N16 SRM_n16CompareName (
    SRM_OBJECT hSRM,
    const char *pacDriverName,
    const char *pacName
        );

BOOLEAN SRM_bRadioReady (
    SRM_OBJECT hSRM,
    FILE *psDevice
        );

BOOLEAN SRM_bSetRadioSpecificData (
    SRM_OBJECT hSRM,
    RADIO_PRIVATE_DATA_OBJECT hData
        );

RADIO_PRIVATE_DATA_OBJECT SRM_hGetRadioSpecificData (
    SRM_OBJECT hSRM
        );

TAG_OBJECT SRM_hGetTag(
    SRM_OBJECT hSRM
        );

BOOLEAN SRM_bReset (
    SRM_OBJECT hSRM
        );

BOOLEAN SRM_bResetModule (
    SRM_OBJECT hSRM,
    MODULE_OBJECT hModule
        );

#endif /* SRM_OBJ_H */
