/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SPORTS header file.
 *
 ******************************************************************************/

#ifndef SPORTS_OBJ_H_
#define SPORTS_OBJ_H_

#include "sms_api.h"
#include "team_obj.h"
#include "league_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Basic sport information structure
typedef struct sport_struct
{
    // Subtype for this object
    SPORTS_ENUM eSubType;

    // Sport abbreviation
    const char *pacAbbreviation;

    // Sport textual name
    const char *pacName;

} SPORT_STRUCT;

// Structure to define sports content
typedef struct sports_object_struct
{
    // CID for this sports type
    CID_OBJECT hId;

    // Sport text & info
    const SPORT_STRUCT *psSport;

    // League Object (const)
    LEAGUE_OBJECT hLeague;

    // List of teams (if any) currently associated with this content
    OSAL_OBJECT_HDL hTeamList;

    SPORTS_BROADCAST_ENUM eBCastType;
    UN8 un8BCastTeamIndex;

} SPORTS_OBJECT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN SPORTS_bAdd (
    CID_OBJECT hId,
    const SPORT_STRUCT *psSport,
    BOOLEAN bCreate
        );

BOOLEAN SPORTS_bAssignId (
    CD_OBJECT hCDO,
    CID_OBJECT hId
        );

BOOLEAN SPORTS_bAssignLeagueId (
    CD_OBJECT hCDO,
    CID_OBJECT hLeagueId,
    LEAGUE_ENUM eLeague
        );

BOOLEAN SPORTS_bAssignTeamId (
    CD_OBJECT hCDO,
    CID_OBJECT hTeamId
        );

BOOLEAN SPORTS_bAssignBCastType (
    CD_OBJECT hCDO,
    SPORTS_BROADCAST_ENUM eBCastType
        );

BOOLEAN SPORTS_bAssignBCastTeamIndex (
    CD_OBJECT hCDO,
    UN8 un8TeamIndex
        );

BOOLEAN SPORTS_bFlushTeams (
    CD_OBJECT hCDO
        );

#endif /* SPORTS_OBJ_H */
