/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

#ifndef SPORTS_MONITOR_OBJ_H_
#define SPORTS_MONITOR_OBJ_H_

#include "sms_api.h"

/**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
SPORTS_MONITOR_OBJECT SPORTS_MONITOR_hCreate (
    SPORTS_SERVICE_OBJECT hSportsService,
    SPORTS_MONITOR_CALLBACK vCallback,
    void *pvCallbackArg
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_MONITOR_eGetEventMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORTS_MONITOR_EVENT_MASK *ptEventMask
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_MONITOR_eSetEventMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORTS_MONITOR_EVENT_MASK tEventMask
        );

void SPORTS_MONITOR_Destroy (
    SPORTS_MONITOR_OBJECT hMonitor
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_MONITOR_eSetAffiliateMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    AFFILIATE_ID tAffiliate,
    SPORTS_MONITOR_EVENT_MASK tEventMask
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_MONITOR_eGetAffiliateMask (
    SPORTS_MONITOR_OBJECT hMonitor,
    AFFILIATE_ID tAffiliate,
    SPORTS_MONITOR_EVENT_MASK *ptEventMask
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_MONITOR_eRemoveAllAffiliates (
    SPORTS_MONITOR_OBJECT hMonitor
        );

SMSAPI_RETURN_CODE_ENUM SPORTS_MONITOR_eIterateChangedAffiliates (
    SPORTS_MONITOR_OBJECT hMonitor,
    SPORT_MONITOR_ITERATOR bIterator,
    void *pvIteratorArg
        );

void SPORTS_MONITOR_vNotifySportListChange (
    SPORTS_MONITOR_OBJECT hMonitor
        );

void SPORTS_MONITOR_vNotifyAffiliateExistanceChange (
    SPORTS_MONITOR_OBJECT hMonitor
        );

void SPORTS_MONITOR_vNotifyAffiliateChange (
    SPORTS_MONITOR_OBJECT hMonitor,
    AFFILIATE_ID tAffiliateId,
    SPORTS_MONITOR_EVENT_MASK tEventMask
        );

void SPORTS_MONITOR_vProcessChange (
    SPORTS_MONITOR_OBJECT hMonitor
        );

#endif /* SPORTS_MONITOR_OBJ_H_ */
