/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SP_SEEK header file.
 *
 ******************************************************************************/

#ifndef SP_SEEK_CONTENT_H_
#define SP_SEEK_CONTENT_H_

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

//  structure used to contain data assocaited with items
//  registered with the service
typedef struct sp_seek_content_registered_item_struct
{
    // type of seek this content is registered for
    SP_SEEK_ENUM eType;

    // identifier for league
    CID_OBJECT hLeagueCID;

    // identifier for team
    CID_OBJECT hTeamCID;

} SP_SEEK_CONTENT_REGISTERED_ITEM_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

void SP_SEEK_CONTENT_vSetServiceSpecificInfo(
    void *pvItem,
    CID_OBJECT hLeagueCID,
    CID_OBJECT hTeamCID,
    SP_SEEK_ENUM eType,
    SEEK_SERVICE_OBJECT hSeekService
        );

CID_OBJECT SP_SEEK_CONTENT_hCID (
    SEEK_CONTENT_OBJECT hSeekContent
        );

const char *SP_SEEK_CONTENT_pacSPSeekTypeText(
    SP_SEEK_ENUM eType
      );

#endif /* SP_SEEK_CONTENT_H_ */
