/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SONG TAG SERVICE header file.
 *
 ******************************************************************************/

#ifndef SONG_TAG_SERVICE_H_
#define SONG_TAG_SERVICE_H_

#include "tag_obj.h"
#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct song_tag_object * SONG_TAG_OBJECT;
#define SONG_TAG_INVALID_OBJECT (SONG_TAG_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

SONG_TAG_OBJECT SONGTAG_hCreate(
    TAG_OBJECT hParentTag
        );

void SONGTAG_vDestroy(
    SONG_TAG_OBJECT hSongTag
        );

void SONGTAG_vSongTagServiceURLUpdate(
    SONG_TAG_SERVICE_ENUM eService,
    char const *pacURL
        );

#endif /* SONG_TAG_SERVICE_H_ */
