/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:Song header file.
 *
 ******************************************************************************/

#ifndef SONG_OBJ_H_
#define SONG_OBJ_H_

#include "standard.h"
#include "sms_api.h"
#include "scache.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Update callback
typedef void (*SONG_OBJECT_EVENT_CALLBACK)(
    SONG_OBJECT hSong,
    SONG_EVENT_MASK tEventMask,
    void *pvEventCallbackArg
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

SONG_OBJECT SONG_hCreate (
	SCACHE_OBJECT hSCache,
    N16 n16Offset
        );

void SONG_vDestroy (
    SONG_OBJECT hSong
        );

BOOLEAN SONG_bUpdateSong (
    SONG_OBJECT hSong,
    const char *pacArtist,
	const char *pacTitle,
	N16 n16Offset
        );

BOOLEAN SONG_bUpdateArtist (
    SONG_OBJECT hSong,
    const char *pacArtistText
        );

BOOLEAN SONG_bUpdateTitle (
    SONG_OBJECT hSong,
    const char *pacTitleText
        );

N16 SONG_n16Offset (
    SONG_OBJECT hSong
        );

BOOLEAN SONG_bUpdateChannelId (
    SONG_OBJECT hSong,
	CHANNEL_ID tId
        );

BOOLEAN SONG_bCompare (
    SONG_OBJECT hSong,
    const char *pacArtistText,
    const char *pacTitleText
        );

BOOLEAN SONG_bUpdateOffset (
    SONG_OBJECT hSong,
	N16 n16Offset
        );

BOOLEAN SONG_bSetDuration (
    SONG_OBJECT hSong
        );

BOOLEAN SONG_bSetDurationValue (
    SONG_OBJECT hSong,
    UN32 un32Duration
        );

BOOLEAN SONG_bSetStatus (
    SONG_OBJECT hSong,
    SMSAPI_SONG_STATUS_ENUM eStatus
        );

BOOLEAN SONG_bSetTimestamp (
    SONG_OBJECT hSong
        );

BOOLEAN SONG_bSetId (
    SONG_OBJECT hSong,
    SONG_ID tId
        );

SONG_ID SONG_tId (
    SONG_OBJECT hSong
        );

BOOLEAN SONG_bRegisterNotification (
    SONG_OBJECT hSong,
    SONG_EVENT_MASK tEventRequestMask,
    SONG_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

void SONG_vUnregisterNotification (
    SONG_OBJECT hSong,
    SONG_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

N16 SONG_n16FindSongByOffset( void *pvArg1, void *pvArg2 );

N16 SONG_n16SongIdEqual(void *pvArg1, void *pvArg2);

#endif /* SONG_OBJ_H */
