/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS Task header file.
 *
 ******************************************************************************/

#ifndef SMS_TASK_H_
#define SMS_TASK_H_

#include "standard.h"
#include "osal.h"

#include "sms_event.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

/* Object handle definitions */
typedef struct sms_task_control_struct * SMS_TASK_HANDLE;
#define SMS_INVALID_TASK_HANDLE (SMS_TASK_HANDLE)NULL

// An instance of this structure must be provided when creating an SMS task
typedef struct sms_task_configuration_struct
{
    // A textual name for this SMS Task
    const char *pacName;

    // Requested stack size (bytes)
    UN32 un32StackSize;

    // Requested priority (should always be LOW)
    OSAL_TASK_PRIORITY_ENUM ePriority;

    // Requested task options
    UN32 un32Options;

    // Registered reporting interval (seconds)
    UN16 un16ReportingInterval;

    // Event queue size (max number of simultaneous pending events)
    UN32 un32EventQueueSize;

    // Requested event handler options
    UN32 un32EventHandlerOptions;

} SMS_TASK_CONFIGURATION_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

SMS_TASK_HANDLE SMST_hInstall (
    SMS_OBJECT hSMS,
    const SMS_TASK_CONFIGURATION_STRUCT *psParameters,
    SMS_OBJECT_EVENT_HANDLER_PROTOTYPE vEventHandler,
    SMS_EVENT_HANDLER *phEventHdlr
        );

void SMST_vUninstall(
    SMS_TASK_HANDLE hTask
        );

#endif /* SMS_TASK_H */
