/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SMS event types header file.
 *
 ******************************************************************************/

#ifndef SMS_EVENT_TYPES_H_
#define SMS_EVENT_TYPES_H_

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Event option type (see above)
typedef UN32 EVENT_OPTIONS_TYPE;

/* Object handle definitions */
typedef struct sms_event_handler_struct * SMS_EVENT_HANDLER;
#define SMS_INVALID_EVENT_HANDLER (SMS_EVENT_HANDLER)NULL

// SMS Event Object Handle
typedef void * SMS_EVENT_HDL;

// Definition used to identify an invalid SMS Event
#define SMS_INVALID_EVENT_HDL ((SMS_EVENT_HDL)(0))

/*
    SMS Event Types
*/

typedef enum sms_event_type_enum
{
    // Invalid event
    SMS_EVENT_INVALID,

    // SMS Task specific events
    SMS_EVENT_INITIALIZE,
    SMS_EVENT_SHUTDOWN,
    SMS_EVENT_SLEEP,
    SMS_EVENT_WAKEUP,

    // Common objects lifetime management events
    SMS_EVENT_RADIO_READY,
    SMS_EVENT_RADIO_RELEASED,
    SMS_EVENT_RESET,
    SMS_EVENT_STOP,
    SMS_EVENT_RELEASE,
    SMS_EVENT_UPDATE_OBJECT,
    SMS_EVENT_REMOVE_DECODER,
    SMS_EVENT_REMOVE_MODULE,
    SMS_EVENT_ERROR,
    SMS_EVENT_ASSOCIATE,
    SMS_EVENT_UNASSOCIATE,
    SMS_EVENT_UPDATE_TIME,
    SMS_EVENT_MODIFY_EVENT_MASK,

    // CM specific events
    SMS_EVENT_TIMEOUT,

    // MODULE specific events
    SMS_EVENT_SAVE_TIME_PARAMS,
    SMS_EVENT_DISPATCH,
    SMS_EVENT_MODIFY_ENGINEERING_DATA_STATE,

    // DECODER specific events
    SMS_EVENT_CCACHE,
    SMS_EVENT_CHANNEL,
    SMS_EVENT_SYNCHRONIZE_TIME,
    SMS_EVENT_UPDATE_SIGNAL,
    SMS_EVENT_UPDATE_ANTENNA,
    SMS_EVENT_PLAY,
    SMS_EVENT_PAUSE,
    SMS_EVENT_SEEK_TIME,
    SMS_EVENT_SEEK_SONG,
    SMS_EVENT_SEEK_PREVIOUS,
    SMS_EVENT_SEEK_NEXT,
    SMS_EVENT_ALL_CHAN_CAT_NOTIFY,
    SMS_EVENT_PRINT_SCACHE,
    SMS_EVENT_CREATE_SONGLIST,
    SMS_EVENT_DESTROY_SONGLIST,
    SMS_EVENT_MODIFY_CHANLIST_EVENT_MASK,
    SMS_EVENT_TONE_GENERATION,
    SMS_EVENT_AUDIO_CONTROL,
    SMS_EVENT_METADATA_WAIT_TIMEOUT,
    SMS_EVENT_METADATA_CHANGED,
    SMS_EVENT_TEXT_REPLACEMENT_TIMEOUT,
    SMS_EVENT_FEATURED_FAVORITES,
    SMS_EVENT_SMART_FAVORITES,
    SMS_EVENT_TUNE_SCAN,
    SMS_EVENT_BROWSE,
    SMS_EVENT_TUNE,
    SMS_EVENT_TUNEMIX_CONFIGURE,
    SMS_EVENT_SPORTS_FLASH,
    SMS_EVENT_TW_NOW,

    // Data Services specific events
    SMS_EVENT_DATASERVICE,
    SMS_EVENT_RFD_INTERFACE,
    SMS_EVENT_ART,
    SMS_EVENT_EPG,

    // Radio specific implementation may use this as their first
    // event to handle radio specific events. This must always
    // be the last SMS event defined.
    SMS_EVENT_RADIO

} SMS_EVENT_TYPE_ENUM;

#endif /* SMS_EVENT_TYPES_H_ */
