/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This file defines the base types & constants used with data services.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef SMS_DEBUG_DEFINITIONS_H_
#define SMS_DEBUG_DEFINITIONS_H_

  /**************/
 /** INCLUDES **/
/**************/

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

#if DEBUG_OBJECT==0
// Override OSAL_DEBUG macro by redefining stdio funcs

// ANSI-C Stdio Definitions (prepare for redefinition)
#ifndef OSAL_USE_NATIVE_STDIO

// ANSI-C stdio APIs
#ifdef printf
#undef printf
#endif

#if __STDC_VERSION__ >= 199901L
#define printf(...)
#else
#define printf if(1);else OSAL.iPrintf
#endif

#ifdef putchar
#undef putchar
#endif

#if __STDC_VERSION__ >= 199901L
#define putchar(...)
#else
#define putchar if(1);else OSAL.iPutchar
#endif

#ifdef puts
#undef puts
#endif

#if __STDC_VERSION__ >= 199901L
#define puts(...)
#else
#define puts if(1);else OSAL.iPuts
#endif

#ifdef getchar
#undef getchar
#endif

#if __STDC_VERSION__ >= 199901L
#define getchar(...)
#else
#define getchar if(1);else OSAL.iGetchar
#endif

#ifdef gets
#undef gets
#endif

#if __STDC_VERSION__ >= 199901L
#define gets(...)
#else
#define gets if(1);else OSAL.pcGets
#endif

#endif /* OSAL_USE_NATIVE_STDIO */

#ifdef SMSAPI_DEBUG_vPrint
#undef SMSAPI_DEBUG_vPrint
#endif

#if __STDC_VERSION__ >= 199901L
#define SMSAPI_DEBUG_vPrint(...)
#else
#define SMSAPI_DEBUG_vPrint if(1);else SMSAPI_DEBUG_vPrintDummy
#endif

#endif /* #if (DEBUG_OBJECT==0) */


  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

#endif /* SMS_DEBUG_DEFINITIONS_H_ */
