/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SHAPE header file.
 *
 ******************************************************************************/

#ifndef SHAPE_OBJ_H_
#define SHAPE_OBJ_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

SHAPE_OBJECT SHAPE_hCreate(
    SMS_OBJECT hParent
        );

BOOLEAN SHAPE_bPreparePoints(
    SHAPE_OBJECT hShape,
    UN16 un16Points,
    SHAPE_TYPE_ENUM eType
        );

BOOLEAN SHAPE_bSetPoint(
    SHAPE_OBJECT hShape,
    UN16 un16Index,
    N32 n32Lat,
    N32 n32Lon,
    UN8 un8FracBits
        );

SMSAPI_RETURN_CODE_ENUM SHAPE_eIterateLines (
    SHAPE_OBJECT hShape,
    SHAPE_LINES_ITERATOR_CALLBACK bCallback,
    void *pvCallbackArg
        );

void SHAPE_vDestroy(
    SHAPE_OBJECT hShape
        );

#endif /* SHAPE_OBJ_H_ */
