/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This module contains the Object:SEEK_EVENT implementation for the
 *  Sirius Module Services (SMS)
 *
 ******************************************************************************/

#include "standard.h"
#include "osal.h"

#include "sms_version.h"
#include "sms_api.h"

#include "seek_event.h"
#include "_seek_event.h"

/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   hChannel
*
* This API is used to retrieve the CHANNEL the SEEK_EVENT is occurring on
*
* Inputs:
*
*   hSeekEvent    A handle to a valid SEEK_EVENT for which the
*                 caller wishes to retrieve the CHANNEL it's occuring on
*
* Outputs:
*
*   A handle to a valid CHANNEL_OBJECT or CHANNEL_INVALID_OBJECT on error
*
*****************************************************************************/
static CHANNEL_OBJECT hChannel (
    SEEK_EVENT_OBJECT hSeekEvent
        )
{
    // the SEEK_EVENT_OBJECT is really a CAL_ALERT object, so just call the
    // appropriate CAL_ALERT object
    return CAL_ALERT.hChannel((CAL_ALERT_OBJECT)hSeekEvent);
}

/*****************************************************************************
*
*   hContent
*
* This API is used to find the SEEK_CONTENT_OBJECT which caused this
* SEEK_EVENT to be generated.
*
* Inputs:
*
*   hAlert - A handle to a valid SEEK_EVENT for which the caller wishes
*            to learn which SEEK_CONTENT object it is associated with.
*
* Outputs:
*
*   A handle to a valid SEEK_CONTENT_OBJECT or
*   SEEK_CONTENT_INVALID_OBJECT on error
*
*****************************************************************************/
static SEEK_CONTENT_OBJECT hContent (
    SEEK_EVENT_OBJECT hSeekEvent
        )
{
    // the SEEK_EVENT_OBJECT is really a CAL_ALERT object, so just call the
    // appropriate CAL_ALERT object. The SEEK_CONTENT_OBJECT is really a
    // CAL_CONTENT_OBJECT so just cast it and pass it back
    return (SEEK_CONTENT_OBJECT)CAL_ALERT.hContent(
                                    (CAL_ALERT_OBJECT)hSeekEvent
                                        );
}


/*****************************************************************************
                             FRIEND FUNCTIONS
*****************************************************************************/

/*****************************************************************************
                             PRIVATE FUNCTIONS
*****************************************************************************/
