/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SEEK header file.
 *
 ******************************************************************************/

#ifndef SEEK_CONTENT_H_
#define SEEK_CONTENT_H_

#include "at_seek_content.h"
#include "tw_seek_content.h"
#include "sp_seek_content.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef union seek_content_union
{
    // Service specific content types
    // Any SEEK_CONTENT structure can be one of the following;
    AT_SEEK_CONTENT_REGISTERED_ITEM_STRUCT sArtistTitle;
    TW_SEEK_CONTENT_REGISTERED_ITEM_STRUCT sTrafficWeather;
    SP_SEEK_CONTENT_REGISTERED_ITEM_STRUCT sSports;

} SEEK_CONTENT_UNION;

// A constant instance of this structure must be defined for each
// service supported. Each service must populate the structure with it's
// own initialization defaults.
// This interface is used by specific service to overload the
// service base implementations which are default implementations.
typedef struct seek_content_obj_interface_struct
{
    // Uninitialize Method
    void (*vUnInit) (
        void *pvServiceSpecific
            );

    // Printer
    N32 (*n32FPrintf) (
        void *pvServiceSpecific,
        FILE *psFile,
        SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
            );

    BOOLEAN (*bSearchForCurrentAfterEnable) (
        void *pvServiceSpecific
            );

} SEEK_CONTENT_OBJ_INTERFACE_STRUCT;

typedef struct seek_content_registered_item_struct
{
    // the service this content is registered with
    SEEK_SERVICE_OBJECT hSeekService;

    // indication of whether the item is enabled or not
    BOOLEAN bEnabled;

    // the service specific content interface
    const SEEK_CONTENT_OBJ_INTERFACE_STRUCT *psInterface;

    // union of service specific information structs
    SEEK_CONTENT_UNION uServiceSpecific;

    TAG_OBJECT hTag;

} SEEK_CONTENT_REGISTERED_ITEM_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
SEEK_CONTENT_REGISTERED_ITEM_STRUCT *SEEK_CONTENT_psCreateRegisteredItem(
    SEEK_SERVICE_OBJECT hSeekService,
    BOOLEAN bInitiallyEnabled
        );

SEEK_CONTENT_REGISTERED_ITEM_STRUCT *SEEK_CONTENT_psRegisteredItem (
    SEEK_CONTENT_OBJECT hSeekContent
        );

void SEEK_CONTENT_vDestroySeekContent(
    SEEK_CONTENT_OBJECT hSeekContent
        );

void SEEK_CONTENT_vDestroyRegisteredItem(
    SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psRegItem
        );

SMSAPI_RETURN_CODE_ENUM SEEK_CONTENT_eUpdateEnabledTag(
    SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psRegItem,
    BOOLEAN bCommit
        );

#endif /* SEEK_CONTENT_H_ */
