/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SCache header file.
 *
 ******************************************************************************/

#ifndef SCACHE_H_
#define SCACHE_H_

#include "standard.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define SCACHE_LIVE_SONG_ARTIST_STRING "<< LIVE >>"
#define SCACHE_LIVE_SONG_TITLE_STRING "<< LIVE >>"
  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct scache_object * SCACHE_OBJECT;
#define SCACHE_INVALID_OBJECT (SCACHE_OBJECT)NULL

// Song Object Event Mask
typedef SMSAPI_EVENT_MASK SCACHE_EVENT_MASK;

// Update callback
typedef void (*SCACHE_OBJECT_EVENT_CALLBACK)(
    SCACHE_OBJECT hSCache,
    SCACHE_EVENT_MASK tEventMask,
    void *pvEventCallbackArg
        );

// SCache Event Mask
#define SCACHE_OBJECT_EVENT_NONE            (0x0001)
#define SCACHE_OBJECT_EVENT_NEW_SONG        (0x0002)
#define SCACHE_OBJECT_EVENT_REMOVE_SONG     (0x0004)
#define SCACHE_OBJECT_EVENT_FLUSHED         (0x0008)
#define SCACHE_OBJECT_EVENT_READY           (0x0010)

#define SCACHE_OBJECT_EVENT_ALL           (    \
    (SCACHE_EVENT_MASK)                        \
    SCACHE_OBJECT_EVENT_NEW_SONG |             \
    SCACHE_OBJECT_EVENT_REMOVE_SONG |          \
    SCACHE_OBJECT_EVENT_FLUSHED  |             \
    SCACHE_OBJECT_EVENT_READY                  \
        )

// SCache song iterator function prototype
typedef BOOLEAN (*SCACHE_SONG_ITERATOR_HANDLER) (
    SONG_OBJECT hSong,
    void *pvArg
        );


  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

SCACHE_OBJECT SCACHE_hCreate (
    PLAYBACK_OBJECT hPlayback
        );

void SCACHE_vDestroy (
    SCACHE_OBJECT hSCache
        );

SONG_OBJECT SCACHE_hSong (
    SCACHE_OBJECT hSCache,
    N16 n16Offset
        );

SONG_OBJECT SCACHE_hCurrentSong (
    SCACHE_OBJECT hSCache
        );

N16 SCACHE_n16NumberOfSongs (
    SCACHE_OBJECT hSCache
        );

N16 SCACHE_n16CurrentSongOffset (
    SCACHE_OBJECT hSCache
        );

SONG_ID SCACHE_tCurrentSongID (
    SCACHE_OBJECT hSCache
        );

SONG_OBJECT SCACHE_hGetSong(
    SCACHE_OBJECT hSCache,
    SONG_ID tId
        );

void SCACHE_vFlush(
    SCACHE_OBJECT hSCache
        );

SONG_OBJECT SCACHE_hGetTailMinusOne (
    SCACHE_OBJECT hSCache
        );

SONG_OBJECT SCACHE_hGetTail (
    SCACHE_OBJECT hSCache
        );

SONG_OBJECT SCACHE_hGetHead (
    SCACHE_OBJECT hSCache
        );

void SCACHE_vRemoveSongFromSCache(
    SCACHE_OBJECT hSCache,
    SONG_ID tId
        );

BOOLEAN SCACHE_bChangeCurrentSongID (
    SCACHE_OBJECT hSCache,
    SONG_ID tSongId
        );

BOOLEAN SCACHE_bRegisterNotification (
    SCACHE_OBJECT hSCache,
    SCACHE_EVENT_MASK tEventRequestMask,
    SCACHE_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

void SCACHE_vUnregisterNotification (
    SCACHE_OBJECT hSCache,
    SCACHE_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

void SCACHE_vUpdate (
    SCACHE_OBJECT hSCache
        );

OSAL_LINKED_LIST_ENTRY SCACHE_hSongLLEntry(
    SCACHE_OBJECT hSCache,
    SONG_ID tSongId
        );

SONG_OBJECT SCACHE_hSongFromLLEntry (
    OSAL_LINKED_LIST_ENTRY hLLEntry
        );

N16 SCACHE_n16CompareSongOrder(
   SONG_ID tId1,
   SONG_ID tId2
       );

void SCACHE_vReady(
    SCACHE_OBJECT hSCache
        );

#if SMS_DEBUG == 1

BOOLEAN SCACHE_bIterateSongs (
    SCACHE_OBJECT hSCache,
    SCACHE_SONG_ITERATOR_HANDLER bIterator,
    void *pvArg
        );
#else

#ifdef SCACHE_bIterateSongs
#undef SCACHE_bIterateSongs
#endif
#define SCACHE_bIterateSongs(a,b,c)

#endif

#endif /* SCACHE_H_ */
