/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:REPORT header file.
 *
 ******************************************************************************/

#ifndef REPORT_OBJ_H_
#define REPORT_OBJ_H_

#include "sms_api.h"
#include "cid_obj.h"
#include "tag_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Structure to define markets
typedef struct market_struct
{
    // Market abbreviation or id
    const char *pacId;

    // Market full name
    const char *pacName;

} MARKET_STRUCT;

typedef struct report_object_struct
{
    // CID for this market
    CID_OBJECT hId;

    // Market text & info
    const MARKET_STRUCT *psMarket;

} REPORT_OBJECT_STRUCT;

typedef CID_OBJECT (*MARKET_CID_CREATOR)(
    CID_POOL hPool,
    UN32 un32MarketId
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN REPORT_bAdd (
    CID_OBJECT hId,
    const MARKET_STRUCT *psMarket,
    BOOLEAN bCreate
        );

BOOLEAN REPORT_bAssignId (
    CD_OBJECT hCDO,
    CID_OBJECT hId,
    BOOLEAN *pbFound
        );

BOOLEAN REPORT_bLoadMarketCidCreator (
    MARKET_CID_CREATOR hCreateMarketCid
        );

MARKET_CID_CREATOR REPORT_hCreateMarketCid( void );

void REPORT_vLoadMarkets ( void );

void REPORT_vClear ( void );

TAG_OBJECT REPORT_hGetRadioSpecificTag(void);

void REPORT_vAllMarketsFound(void);

UN16 REPORT_un16CountConfirmedMarkets( void );

#endif /* REPORT_OBJ_H */
