/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:Decoder header file.
 *
 ******************************************************************************/

#ifndef PLAYBACK_OBJ_H
#define PLAYBACK_OBJ_H

#include "standard.h"

#include "sms_api.h"
#include "sms_event.h"
#include "scache.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
#define PLAYBACK_INVALID_TIME_FROM_START UN32_MAX
#define PLAYBACK_INVALID_DURATION_OF_TRACK UN32_MAX

typedef struct playback_stats_struct
{
    UN8 un8FillPercentage; // Percent x100
    UN8 un8PlayPercentage; // Percent x100
    N32 n32TimeOffset; // Seconds
    UN32 un32TimeFromTrackStart; // Seconds
    UN32 un32DurationOfTrack; // Seconds
    UN16 un16TracksBefore;
    UN16 un16TracksRemaining;
} PLAYBACK_STATS_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

PLAYBACK_OBJECT PLAYBACK_hCreate (
    DECODER_OBJECT hDecoder
        );

void PLAYBACK_vDestroy (
    PLAYBACK_OBJECT hPlayback
        );

void PLAYBACK_vUpdatePause (
    PLAYBACK_OBJECT hPlayback,
    BOOLEAN bPaused
        );

void PLAYBACK_vUpdatePlaybackParams(
    PLAYBACK_OBJECT hPlayback,
    UN32 un32WarningOffset
        );

void PLAYBACK_vWarningOccurred (
    PLAYBACK_OBJECT hPlayback
        );

void PLAYBACK_vLimitOccurred (
    PLAYBACK_OBJECT hPlayback
        );

SCACHE_OBJECT PLAYBACK_hSCache (
    PLAYBACK_OBJECT hPlayback
        );

void PLAYBACK_vUpdateSCache (
    PLAYBACK_OBJECT hPlayback
        );

void PLAYBACK_vPostCreateSongList(
    PLAYBACK_OBJECT hPlayback,
    SONGLIST_OBJECT hSonglist
        );

void PLAYBACK_vProcessCreateSongList(
    PLAYBACK_OBJECT hPlayback,
    SONGLIST_OBJECT hSonglist
        );

void PLAYBACK_vPostDestroySongList(
    PLAYBACK_OBJECT hPlayback,
    SONGLIST_OBJECT hSonglist
        );

void PLAYBACK_vProcessDestroySongList(
    PLAYBACK_OBJECT hPlayback,
    SONGLIST_OBJECT hSonglist
        );

void PLAYBACK_vSetError (
    PLAYBACK_OBJECT hPlayback,
    PLAYBACK_ERROR_CODE_ENUM eError
        );

void PLAYBACK_vUpdatePlaybackInfo (
    PLAYBACK_OBJECT hPlayback,
    const PLAYBACK_STATS_STRUCT *psStats
        );

void PLAYBACK_vUpdateReaminingTime (
    PLAYBACK_OBJECT hPlayback,
    UN32 un32RemainingTime
        );

void PLAYBACK_vUpdateTotalDuration (
    PLAYBACK_OBJECT hPlayback,
    UN32 un32Duration
        );

void PLAYBACK_vFlushTimeInfo (
    PLAYBACK_OBJECT hPlayback
        );

#endif /* PLAYBACK_OBJ_H */
