/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Phonetics Interface header file.
 *
 ******************************************************************************/

#ifndef PHONETICS_INTERFACE_H_
#define PHONETICS_INTERFACE_H_

#include "sms_api.h"
#include "phonetics_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// Defined as a string instead of a char for
// convenience
#define PHONETICS_ENTRY_DELIMITER "|"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef void * PHONETICS_INTERFACE_OBJECT;
#define PHONETICS_INTERFACE_INVALID_OBJECT ((PHONETICS_INTERFACE_OBJECT)NULL)

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

// The phonetics plugin interface
typedef struct phonetics_plugin_interface_struct
{
    const DSI tDSI;
    const size_t tOTABufferByteSize;

    PHONETICS_INTERFACE_OBJECT (*hInit) (
        PHONETICS_SERVICE_OBJECT hPhoneticsService,
        SMS_OBJECT hParent
            );

    void (*vUninit) (
        PHONETICS_INTERFACE_OBJECT hInterface
            );

    BOOLEAN (*bAddTable) (
        PHONETICS_INTERFACE_OBJECT hInterface,
        PHONETICS_FILE_TYPE_ENUM eType,
        UN8 un8TableId,
        UN8 un8TableDefVer,
        UN16 un16TableContentVer
            );

    BOOLEAN (*bProcessMessage) (
        PHONETICS_INTERFACE_OBJECT hInterface,
        OSAL_BUFFER_HDL hPayload
            );

} PHONETICS_PLUGIN_INTERFACE_STRUCT;

// Structure used to report new phonetics information
// to the manager
typedef struct phonetics_list_node_struct
{
    PHONETICS_PHONETIC_ID_STRUCT sID;
    OSAL_LINKED_LIST_ENTRY hEntry;

    BOOLEAN bPhoneticsPresent;
    STRING_OBJECT ahPhonetics[PHONETICS_MAX_LANGUAGES];

} PHONETICS_LIST_NODE_STRUCT;


// The phonetics manager's interface APIs
typedef struct phonetics_mgr_interface_struct
{
    BOOLEAN (*bNewList) (
        PHONETICS_SERVICE_OBJECT hPhoneticsService,
        PHONETICS_FILE_TYPE_ENUM eType,
        UN8 un8TableDefVer,
        UN16 un16TableContentVer,
        OSAL_OBJECT_HDL hPhoneticsList
            );

    PHONETICS_FILE_TYPE_ENUM (*eTypeForId) (
        UN8 un8TableId
            );

    OSAL_OBJECT_HDL (*hCreatePhoneticsList) (
        PHONETICS_FILE_TYPE_ENUM eType
            );

    BOOLEAN (*bConcatPhoneticData) (
        STRING_OBJECT hAggregate,
        STRING_OBJECT hNewPhonetics
            );

    N16 (*n16CompareNode) (
        PHONETICS_LIST_NODE_STRUCT *psNode1,
        PHONETICS_LIST_NODE_STRUCT *psNode2
            );

    BOOLEAN (*bRemoveNode) (
        PHONETICS_LIST_NODE_STRUCT *psNode,
        void *pvUnused
            );

    char const *(*pacFileType) (
        PHONETICS_FILE_TYPE_ENUM eType
            );

} PHONETICS_MGR_INTERFACE_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// Interface into the phonetics plugin
extern const PHONETICS_PLUGIN_INTERFACE_STRUCT GsPhoneticsIntf;

// Interface into the phonetics manager
extern const PHONETICS_MGR_INTERFACE_STRUCT GsPhoneticsMgrIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

#endif /* PHONETICS_INTERFACE_H_ */
