/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:MUSIC header file.
 *
 ******************************************************************************/

#ifndef MUSIC_OBJ_H_
#define MUSIC_OBJ_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct music_song_tag_struct
{
    // CIDs for this object (as new song tag services are added, add CIDs here)
    CID_OBJECT hITunesTagId;

} MUSIC_SONG_TAG_STRUCT;

typedef struct music_object_struct
{
    // Sub type(identifier) for this object
    MUSIC_ENUM eSubType;

    // CIDs for this object
    CID_OBJECT hArtistId;
    CID_OBJECT hSongId;

    MUSIC_SONG_TAG_STRUCT sSongTag;

} MUSIC_OBJECT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN MUSIC_bValidSubId (
    MUSIC_ENUM eType
        );

#endif /* MUSIC_OBJ_H */
