/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:MOVIES_MGR header file.
 *
 ******************************************************************************/

#ifndef MOVIES_MGR_OBJ_H_
#define MOVIES_MGR_OBJ_H_

#include "sms_api.h"
#include "movies_db_constants.h"
#include "sql_interface_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
MOVIE_OBJECT MOVIES_MGR_hGetMovieForID (
    SMS_OBJECT hParent,
    MOVIE_ID tMovieID
        );

BOOLEAN MOVIES_MGR_bGetRatingInfo (
    MOVIES_SERVICE_OBJECT hMovieMgr,
    MOVIE_RATING_SYS_CODE tSysCode,
    MOVIE_RATING_CODE tRatingCode,
    MOVIE_RATING_STRUCT *psRating
        );

BOOLEAN MOVIES_MGR_bShouldProcessTimes (
    MOVIES_SERVICE_OBJECT hMovieMgr,
    MOVIE_STATE_ID tStateID
        );

BOOLEAN MOVIES_MGR_bPrepareForRefDBUpdate (
    MOVIES_SERVICE_OBJECT hMovieMgr,
    STRING_OBJECT *phInUseDB,
    STRING_OBJECT *phNextDB
        );

BOOLEAN MOVIES_MGR_bStartDBUpdate (
    SQL_INTERFACE_OBJECT hConnection,
    char *pcSQLCommandBuffer,
    size_t tBufferSize
        );

BOOLEAN MOVIES_MGR_bEndDBUpdate (
    SQL_INTERFACE_OBJECT hConnection,
    char *pacBuffer,
    size_t tBufferSize,
    MOVIE_VERSION tNewBaselineVersion
        );

BOOLEAN MOVIES_MGR_bRemoveTheater (
    SQL_INTERFACE_OBJECT hSQLConnection,
    char *pcSQLCommandBuffer,
    size_t tBufferSize,
    THEATER_ID tID
        );

BOOLEAN MOVIES_MGR_bInsertTheater (
    SQL_INTERFACE_OBJECT hSQLConnection,
    char *pcSQLCommandBuffer,
    size_t tBufferSize,
    THEATER_ROW_STRUCT *psTheaterRow
        );

BOOLEAN MOVIES_MGR_bUpdateTheater (
    SQL_INTERFACE_OBJECT hSQLConnection,
    char *pcSQLCommandBuffer,
    size_t tBufferSize,
    THEATER_ROW_STRUCT *psTheaterRow,
    BOOLEAN bAmenitiesUpdated
        );

BOOLEAN MOVIES_MGR_bClearRatings (
    SQL_INTERFACE_OBJECT hSQLConnection
        );

BOOLEAN MOVIES_MGR_bInsertRatings (
    SQL_INTERFACE_OBJECT hSQLConnection,
    MOVIE_RATINGS_ROW_STRUCT *psRatingsRow
        );
#endif /* MOVIES_MGR_OBJ_H_ */
