/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:Module Version header file.
 *
 ******************************************************************************/

#ifndef MODULE_VERSION_OBJ_H_
#define MODULE_VERSION_OBJ_H_

#include "radio.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct module_version_object * MODULE_VERSION_OBJECT;
#define MODULE_VERSION_INVALID_OBJECT (MODULE_VERSION_OBJECT)NULL

#define MODULE_VERSION_STRING_HW_NAME_LEN 10
  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/
typedef struct module_version_info_struct
{
    UN8 un8ModuleTypeIDA;
    UN8 un8ModuleTypeIDB;
    UN8 un8ModuleTypeIDC;
    UN8 un8ModuleHWRevA;
    UN8 un8ModuleHWRevB;
    UN8 un8ModuleHWRevC;
    UN8 un8ModSWRevMajor;
    UN8 un8ModSWRevMinor;
    UN8 un8ModSWRevInc;
    UN8 un8ProtocolRevMajor;
    UN8 un8ProtocolRevMinor;
    UN8 un8ProtocolRevInc;
    UN8 un8BBRevMajor;
    UN8 un8BBRevMinor;
    UN8 un8BBRevInc;
    UN8 un8HDecRevMajor;
    UN8 un8HDecRevMinor;
    UN8 un8HDecRevInc;
    UN8 un8RFRevMajor;
    UN8 un8RFRevMinor;
    UN8 un8RFRevInc;
    UN8 un8SPLRevMajor;
    UN8 un8SPLRevMinor;
    UN8 un8SPLRevInc;

    // SXi v3.0 Features
    UN8 un8MaxSmartFavorites;
    UN8 un8MaxTuneMix;
    UN8 un8MaxSportsFlash;
    UN8 un8MaxTWNow;

    UN32 un32Capability;
    const char *pcModuleHwName;
    BOOLEAN bModuleVersionAvailable;
    RADIO_MODULE_FEATURE_MASK tFeatures;

} MODULE_VERSION_INFO_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

#define MODULE_PROTOCOL_VERSION_PACK(Maj, Min, Inc) \
    PACKUINT32(0, Maj, Min, Inc)

#define MODULE_SW_VERSION_PACK(Maj, Min, Inc) \
    PACKUINT32(0, Maj, Min, Inc)

#define MODULE_MODULE_VERSION_PACK(Maj, Min, Inc) \
    PACKUINT32(0, Maj, Min, Inc)

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

void MODULE_VERSION_vInitializeObject(
    MODULE_VERSION_OBJECT hModuleVersion
        );

void MODULE_VERSION_vUpdate(
    MODULE_OBJECT hModule,
    MODULE_VERSION_INFO_STRUCT const *psModuleVerInfo
        );

MODULE_VERSION_OBJECT MODULE_VERSION_hCreate(
    MODULE_OBJECT hOwner
        );

void MODULE_VERSION_vDestroy (
    MODULE_VERSION_OBJECT hModuleVersion
        );

BOOLEAN MODULE_VERSION_bGetSwVersion(
    MODULE_OBJECT hModule,
    UN32 *un32SwVer
        ) ;

BOOLEAN MODULE_VERSION_bGetModuleType(
    MODULE_OBJECT hModule,
    UN32 *un32ModuleType
        );

BOOLEAN MODULE_VERSION_bGetModuleFeatureMask(
    MODULE_OBJECT hModule,
    RADIO_MODULE_FEATURE_MASK *tFeatureMask
        );

BOOLEAN MODULE_VERSION_bGetProtocolVersion(
    MODULE_OBJECT hModule,
    UN32 *un32ProtocolVer
        );

BOOLEAN MODULE_VERSION_bMaxTuneMix(
    MODULE_OBJECT hModule,
    UN8 *pun8MaxTuneMix
        );

BOOLEAN MODULE_VERSION_bMaxSmartFavs(
    MODULE_OBJECT hModule,
    UN8 *un8MaxSmartFavs
        );

BOOLEAN MODULE_VERSION_bMaxSportsFlash(
    MODULE_OBJECT hModule,
    UN8 *pun8MaxSportsFlash
        );

BOOLEAN MODULE_VERSION_bMaxTWNow(
    MODULE_OBJECT hModule,
    UN8 *pun8MaxTWNow
        );

#endif /* MODULE_VERSION_OBJ_H_ */
