/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Non-Nav Maps a Interface header file.
 *
 ******************************************************************************/

#ifndef MAPS_INTERFACE_H_
#define MAPS_INTERFACE_H_

#include "standard.h"
#include "osal.h"
#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Interface handle
typedef struct maps_interface_object * MAPS_INTERFACE_OBJECT;
#define MAPS_INTERFACE_INVALID_OBJECT (MAPS_INTERFACE_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/
// The Maps interface APIs
typedef struct maps_plugin_interface_struct
{
    const size_t tOTABufferByteSize;

    const DSI tDSI;

    const size_t tMaxVersionBitlen;

    MAPS_INTERFACE_OBJECT (*hInit) (
        MAPS_SERVICE_OBJECT hMapsService,
        SMS_OBJECT hParent
            );

    void (*vUnInit) (
        MAPS_INTERFACE_OBJECT hInterface
            );

    BOOLEAN (*bProcessMessage) (
        MAPS_INTERFACE_OBJECT hInterface,
        OSAL_BUFFER_HDL *phPayload
            );
} MAPS_PLUGIN_INTERFACE_STRUCT;

// The Maps manager's interface APIs
typedef struct maps_mgr_interface_struct
{
    BOOLEAN (*bAddUpdate) (
        MAPS_SERVICE_OBJECT hMapsService,
        const char *pacSubname,
        UN32 un32NewVersion,
        UN16 un16HorResolution,
        FILE *psRFDFile,
        size_t tFileSize
            );

    UN32 (*un32GetVersionForSubname) (
        MAPS_SERVICE_OBJECT hMapsService,
        const char *pacSubname
            );

    N8 (*n8ComparePriority) (
        MAPS_SERVICE_OBJECT hMapsService,
        const char *pacSubnameA,
        const char *pacSubnameB
            );
} MAPS_MGR_INTERFACE_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// Interface into the Non-Nav Maps plugins
extern const MAPS_PLUGIN_INTERFACE_STRUCT GsMapsPluginIntf;

// Interface into the maps manager
extern const MAPS_MGR_INTERFACE_STRUCT GsMapsMgrIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

#endif /* MAPS_INTERFACE_H_ */
