/*****************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 ******************************************************************************/


#include "_link_status_information_obj.h"
#include "link_status_information_obj.h"
#include "engineering_data_obj.h"

#include "sms_api_debug.h"
static const char *gpacThisFile = __FILE__;

/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/
/*****************************************************************************
*
*   hNumberConfirmationTimeouts
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eNumberConfirmationTimeouts (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    NUMBER_CONFIRMATION_TIMEOUTS *ptNumConfirmTimeouts
        )
{
    LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner = FALSE;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_ERROR;

    psObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)hLinkStatusInfo;

    bOwner = SMSO_bOwner((SMS_OBJECT)hLinkStatusInfo);
    if ( bOwner == TRUE )
    {
        if ( ptNumConfirmTimeouts != NULL )
        {
            *ptNumConfirmTimeouts = psObj->tNumberConfirmationTimeouts;
            eReturnCode = SMSAPI_RETURN_CODE_SUCCESS;
        }
    }
    else
    {
        eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    }
    return eReturnCode;
}


/*****************************************************************************
*
*   eNumberDataPacketsDropped
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eNumberDataPacketsDropped (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptDataPacketsDropped
        )
{
    LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner = FALSE;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_ERROR;

    psObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)hLinkStatusInfo;

    bOwner = SMSO_bOwner((SMS_OBJECT)hLinkStatusInfo);
    if ( bOwner == TRUE )
    {
        if ( ptDataPacketsDropped != NULL )
        {
            *ptDataPacketsDropped = psObj->tNumberDataPacketsDropped;
            eReturnCode = SMSAPI_RETURN_CODE_SUCCESS;
        }
    }
    else
    {
        eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    }
    return eReturnCode;
}


/*****************************************************************************
*
*   eNumberDataPacketsTransmitted
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eNumberDataPacketsTransmitted (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptDataPacketsTransmitted
        )
{
    LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner = FALSE;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_ERROR;

    psObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)hLinkStatusInfo;

    bOwner = SMSO_bOwner((SMS_OBJECT)hLinkStatusInfo);
    if ( bOwner == TRUE )
    {
        if ( ptDataPacketsTransmitted != NULL )
        {
            *ptDataPacketsTransmitted =
                    psObj->tNumberDataPacketsTransmitted;
            eReturnCode = SMSAPI_RETURN_CODE_SUCCESS;
        }
    }
    else
    {
        eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    }
    return eReturnCode;
}

/*****************************************************************************
*
*   eNumberAudioPacketsDropped
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eNumberAudioPacketsDropped (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptAudioPacketsDropped
        )
{
    LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner = FALSE;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_ERROR;

    psObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)hLinkStatusInfo;

    bOwner = SMSO_bOwner((SMS_OBJECT)hLinkStatusInfo);
    if ( bOwner == TRUE )
    {
        if ( ptAudioPacketsDropped != NULL )
        {
            *ptAudioPacketsDropped = psObj->tNumberAudioPacketsDropped;
            eReturnCode = SMSAPI_RETURN_CODE_SUCCESS;
        }
    }
    else
    {
        eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    }
    return eReturnCode;
}


/*****************************************************************************
*
*   eNumberAudioPacketsTransmitted
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eNumberAudioPacketsTransmitted (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptAudioPacketsTransmitted
        )
{
    LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner = FALSE;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_ERROR;

    psObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)hLinkStatusInfo;

    bOwner = SMSO_bOwner((SMS_OBJECT)hLinkStatusInfo);
    if ( bOwner == TRUE )
    {
        if ( ptAudioPacketsTransmitted != NULL )
        {
            *ptAudioPacketsTransmitted =
                    psObj->tNumberAudioPacketsTransmitted;
            eReturnCode = SMSAPI_RETURN_CODE_SUCCESS;
        }
    }
    else
    {
        eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    }
    return eReturnCode;
}


/*****************************************************************************
*
*   n32FPrintf
*
*****************************************************************************/
static N32 n32FPrintf (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    FILE *psFile
        )
{
    N32 n32Return = 0;
    BOOLEAN bOwner = FALSE;

    if (   ( psFile == NULL )
        || ( hLinkStatusInfo == LINK_STATUS_INFORMATION_INVALID_OBJECT )
       )
    {
        return EOF;
    }

    bOwner = SMSO_bOwner((SMS_OBJECT)hLinkStatusInfo);
    if ( bOwner == TRUE )
    {
        NUMBER_CONFIRMATION_TIMEOUTS tNumConfirmTimeouts;
        PACKET_COUNTER_NUMBER tPacketCounter;
        SMSAPI_RETURN_CODE_ENUM eReturn;

        n32Return += fprintf(psFile, "Link Status Information Object\n");

        //numberConfirmationTimeouts
        eReturn = LINK_STATUS_INFORMATION.eNumberConfirmationTimeouts(
                hLinkStatusInfo, &tNumConfirmTimeouts);
        if ( eReturn == SMSAPI_RETURN_CODE_SUCCESS )
        {
            n32Return += fprintf(psFile, "NumberConfirmationTimeouts  = %u\n",
                tNumConfirmTimeouts);
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
                LINK_STATUS_INFORMATION_OBJECT_NAME
	            ": Failed to get Number Confirmation Timeouts");
        }

        //numberDataPacketsTransmitted
        eReturn = LINK_STATUS_INFORMATION.eNumberDataPacketsTransmitted(
                hLinkStatusInfo, &tPacketCounter);
        if ( eReturn == SMSAPI_RETURN_CODE_SUCCESS )
        {
            n32Return += fprintf(psFile, "NumberDataPacketsTransmitted  = %u\n",
                tPacketCounter);
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            LINK_STATUS_INFORMATION_OBJECT_NAME
	            ": Failed to get Number Data Packets Transmitted");
        }

        //numberDataPacketsDropped
        eReturn = LINK_STATUS_INFORMATION.eNumberDataPacketsDropped(
            hLinkStatusInfo, &tPacketCounter);
        if ( eReturn == SMSAPI_RETURN_CODE_SUCCESS )
        {
            n32Return += fprintf(psFile, "NumberDataPacketsDropped  = %u\n",
                tPacketCounter);
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            LINK_STATUS_INFORMATION_OBJECT_NAME
	            ": Failed to get Number Data Packets Dropped");
        }

        //numberAudioPacketsTransmitted
        eReturn = LINK_STATUS_INFORMATION.eNumberAudioPacketsTransmitted(
            hLinkStatusInfo, &tPacketCounter);
        if ( eReturn == SMSAPI_RETURN_CODE_SUCCESS )
        {
            n32Return += fprintf(psFile, "NumberAudioPacketsTransmitted  = %u\n",
                tPacketCounter);
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            LINK_STATUS_INFORMATION_OBJECT_NAME
	            ": Failed to get Number Audio Packets Transmitted");
        }

        //numberAudioPacketsDropped
        eReturn = LINK_STATUS_INFORMATION.eNumberAudioPacketsDropped(
            hLinkStatusInfo, &tPacketCounter);
        if ( eReturn == SMSAPI_RETURN_CODE_SUCCESS )
        {
            n32Return += fprintf(psFile, "NumberAudioPacketsDropped  = %u\n",
                tPacketCounter);
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            LINK_STATUS_INFORMATION_OBJECT_NAME
	            ": Failed to get Number Audio Packets Dropped");
        }
    }
    else
    {
        SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            LINK_STATUS_INFORMATION_OBJECT_NAME
	            ": Not owner");
	    return EOF;

    }
    return n32Return;
}

/*****************************************************************************
                             FRIEND FUNCTIONS
*****************************************************************************/


/*****************************************************************************
*
*   LINK_STATUS_INFORMATION_bUpdateLinkStatusInformation
*
*****************************************************************************/
BOOLEAN LINK_STATUS_INFORMATION_bUpdateLinkStatusInformation(
    DECODER_OBJECT hDecoder,
    LINK_INFORMATION_STRUCT const *psNewLinkStatusInformation
        )
{

    BOOLEAN bReturn = TRUE, bOwner;
    SMSAPI_RETURN_CODE_ENUM eReturn;
    LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;

    bOwner = SMSO_bOwner((SMS_OBJECT) hDecoder);
    if( bOwner == TRUE )
    {
        eReturn = eAccessObjectFromDecoder(hDecoder, &psObj);
        if ( eReturn != SMSAPI_RETURN_CODE_SUCCESS )
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
                    LINK_STATUS_INFORMATION_OBJECT_NAME
                    ": Unable to access LINK_STATUS_INFORMATION_OBJECT");
            bReturn = FALSE;
        }

        //Trigger update if any of the values have changed
        if (  (bReturn == TRUE )
           && (  ( psObj->tNumberAudioPacketsDropped
                 != psNewLinkStatusInformation->un32NumberAudioPacketsDropped
                 )
              || ( psObj->tNumberAudioPacketsTransmitted
                 != psNewLinkStatusInformation->un32NumberAudioPacketsTx
                 )
              || ( psObj->tNumberDataPacketsDropped
                 != psNewLinkStatusInformation->un32NumberDataPacketsDropped
                 )
              || ( psObj->tNumberDataPacketsTransmitted
                 != psNewLinkStatusInformation->un32NumberDataPacketsTx
                 )
              || ( psObj->tNumberConfirmationTimeouts
                 != psNewLinkStatusInformation->un32NumberConfirmTimeouts
                 )
              )
           )
        {
            psObj->tNumberAudioPacketsDropped =
                    psNewLinkStatusInformation->un32NumberAudioPacketsDropped;
            psObj->tNumberAudioPacketsTransmitted  =
                    psNewLinkStatusInformation->un32NumberAudioPacketsTx;
            psObj->tNumberDataPacketsDropped =
                    psNewLinkStatusInformation->un32NumberDataPacketsDropped;
            psObj->tNumberDataPacketsTransmitted =
                    psNewLinkStatusInformation->un32NumberDataPacketsTx;
            psObj->tNumberConfirmationTimeouts =
                    psNewLinkStatusInformation->un32NumberConfirmTimeouts;
            bReturn = TRUE;
        }
    }
    return bReturn;
}

/*****************************************************************************
*
*   LINK_STATUS_INFORMATION_vInitializeObject
*
*****************************************************************************/
void LINK_STATUS_INFORMATION_vInitializeObject(
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInformation
        )
{
    LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;

    psObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)hLinkStatusInformation;
    // Initialize state attributes
	*psObj = gsObjectDefaults;
	return;
}

/*****************************************************************************
*
*   LINK_STATUS_INFORMATION_hCreate
*
*****************************************************************************/
LINK_STATUS_INFORMATION_OBJECT LINK_STATUS_INFORMATION_hCreate(
    ENGINEERING_DATA_OBJECT hOwner
        )
{
	LINK_STATUS_INFORMATION_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner;

    // Verify ownership of parent object
    bOwner = SMSO_bOwner((SMS_OBJECT)hOwner);

    if ( bOwner == FALSE )
    {
        return LINK_STATUS_INFORMATION_INVALID_OBJECT;
    }

    // Create an instance of this object
    psObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)
            SMSO_hCreate(
                LINK_STATUS_INFORMATION_OBJECT_NAME,
                sizeof(LINK_STATUS_INFORMATION_OBJECT_STRUCT),
                (SMS_OBJECT)hOwner,
                FALSE);

    if( psObj == NULL )
    {
        // Error!
        return LINK_STATUS_INFORMATION_INVALID_OBJECT;
    }

    LINK_STATUS_INFORMATION_vInitializeObject(
            (LINK_STATUS_INFORMATION_OBJECT)psObj);

	return (LINK_STATUS_INFORMATION_OBJECT)psObj;
}

/*****************************************************************************
*
*   LINK_STATUS_INFORMATION_vDestroy
*
*****************************************************************************/
void LINK_STATUS_INFORMATION_vDestroy (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInformation
        )
{
    // Free object instance
    SMSO_vDestroy((SMS_OBJECT)hLinkStatusInformation);
    return;
}
/*****************************************************************************
                             PRIVATE FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   eAccessObjectFromDecoder
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eAccessObjectFromDecoder(
    DECODER_OBJECT hDecoder,
    LINK_STATUS_INFORMATION_OBJECT_STRUCT **ppsObj
        )
{
    BOOLEAN bOwner;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_INVALID_INPUT;

    // Verify caller is already the owner of the object.
    // If not this function may not be called.
    bOwner = SMSO_bOwner((SMS_OBJECT)hDecoder);
    if( bOwner == TRUE )
    {
        *ppsObj = (LINK_STATUS_INFORMATION_OBJECT_STRUCT *)
                ENGINEERING_DATA.hLinkStatusInformation(hDecoder);
        if( *ppsObj == NULL )
        {
            eReturnCode = SMSAPI_RETURN_CODE_NOT_FOUND;
        }
        else
        {
            eReturnCode = SMSAPI_RETURN_CODE_SUCCESS;
        }
    }
    else
    {
        eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    }
    return eReturnCode;
}
