/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the FUEL_STATION header file.
 *
 ******************************************************************************/

#ifndef FUEL_STATION_OBJ_H_
#define FUEL_STATION_OBJ_H_

#include "sms_api.h"
#include "fuel_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef STRING_OBJECT (*FUEL_TYPE_TEXT_CALLBACK) (
    UN8 un8FuelType,
    void *pvArg
        );

typedef FUEL_TYPE_ENUM (*FUEL_TYPE_ENUM_CALLBACK) (
    UN8 un8FuelType,
    void *pvArg
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

FUEL_STATION_OBJECT FUEL_STATION_hCreate (
    SMS_OBJECT hOwner,
    FUEL_STATION_ROW_STRUCT *psStationRow,
    FUEL_PRICE_SORT_METHOD_ENUM eFuelPriceSortMethod,
    size_t tServiceDescriptorSize
        );

FUEL_STATION_OBJECT FUEL_STATION_hCreateDummy (
    SMS_OBJECT hOwner
        );

BOOLEAN FUEL_STATION_bSetDummyLocId (
    FUEL_STATION_OBJECT,
    LOC_ID tLocId
        );

void FUEL_STATION_vDestroy (
    FUEL_STATION_OBJECT hFuelStation
        );

#if 0

// Leaving this code here for future reference
BOOLEAN FUEL_STATION_bUpdate (
    FUEL_STATION_OBJECT hFuelStation,
    BOOLEAN bOverwriteAllFields,
    BOOLEAN bAmenitiesUpdated,
    FUEL_STATION_ROW_STRUCT *psStationRow
        );
#endif

BOOLEAN FUEL_STATION_bUpdatePrices (
    FUEL_STATION_OBJECT hFuelStation,
    FUEL_PRICE_SORT_METHOD_ENUM eFuelPriceSortMethod,
    FUEL_TYPE_TEXT_CALLBACK hFuelTextCallback,
    FUEL_TYPE_ENUM_CALLBACK eFuelTypeCallback,
    FUEL_PRICE_ROW_STRUCT *psPriceRow,
    UN8 un8TextVersion,
    void *pvCallbackArg
        );

BOOLEAN FUEL_STATION_bFlushPrices (
    FUEL_STATION_OBJECT hFuelStation,
    UN32 un32PriceExpireAge,
    UN32 *pun32OldestPriceAfterFlush
        );

BOOLEAN FUEL_STATION_bUpdateRefuelingPositions (
    FUEL_STATION_OBJECT hFuelStation,
    UN16 un16ReportTime,
    FUEL_POSITION_UPDATE_STRUCT *pasPositions,
    size_t tNumPositions
        );

N16 FUEL_STATION_n16LogoId(
    FUEL_STATION_OBJECT hFuelStation
        );

N16 FUEL_STATION_n16Compare (
    FUEL_STATION_OBJECT hFuelStation1,
    FUEL_STATION_OBJECT hFuelStation2
        );

BOOLEAN FUEL_STATION_bSerializeData (
    FUEL_STATION_OBJECT hFuelStation,
    FUEL_DB_UPDATE_PRICE_TABLE_STRUCT *psDBUpdate
        );

#endif /* FUEL_STATION_OBJ_H_ */
