/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:FUEL_MGR header file.
 *
 ******************************************************************************/

#ifndef FUEL_MGR_OBJ_H_
#define FUEL_MGR_OBJ_H_

#include "dataservice_mgr_impl.h"
#include "fuel_interface.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// For validating the current time
#define FUEL_ZERO_DATE (1307383609)

// Constant shared by manager & station
#define FUEL_SECONDS_PER_DAY (86400)

// Convert from a region / station id
// pair to a locid value
#define FUEL_REG_STATID_TO_LOCID(reg, stat) \
    (((reg) << 16) | (stat))

// Convert a locid to a region or station id
#define FUEL_LOCID_TO_REG(locid) ((locid) >> 16)
#define FUEL_LOCID_TO_STATID(locid) ((locid) & 0xFFFF)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct fuel_mgr_text_description_struct
{
    // The type of fuel
    UN8 un8FuelType;
    FUEL_TYPE_ENUM eFuelType;

    // The descriptive texts for this fuel type
    STRING_OBJECT hShortFuelName;
    STRING_OBJECT hLongFuelName;

} FUEL_TEXT_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

/* Used for common object Public Prototypes */
FUEL_SERVICE_OBJECT FUEL_MGR_hStart (
    DATASERVICE_CREATE_STRUCT *psCreate,
    DATASERVICE_TYPE_ENUM eServiceType,
    BOOLEAN bEnableLogoSupport,
    const FUEL_OTA_INTERFACE_STRUCT *psOTAInterface,
    const FUEL_DB_INTERFACE_STRUCT *psDBInterface,
    FUEL_PRICE_SORT_METHOD_ENUM eFuelPriceSortMethod,
    DATASERVICE_EVENT_MASK tEventRequestMask,
    DATASERVICE_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg,
    DATASERVICE_OPTIONS_STRUCT const *psOptions
        );

N64 FUEL_MGR_n64GeneratePhoneFromFields (
    UN16 un16AreaCode,
    UN16 un16Exchange,
    UN16 un16Number
        );

STRING_OBJECT FUEL_MGR_hPhoneToString (
    N64 n64Phone
        );

SMSAPI_RETURN_CODE_ENUM FUEL_MGR_eProcessAmenities (
    SMS_OBJECT hOwner,
    size_t tNumAmenities,
    AMENITY_STRUCT *pasFuelAmenities,
    UN32 un32RawAmenitiesData
        );

IMAGE_OBJECT FUEL_MGR_hBrandLogo (
    SMS_OBJECT hOwner,
    FUEL_BRAND_LOGO_IMAGE_TYPE_ENUM eLogoType,
    N16 n16LogoId
        );

SMSAPI_RETURN_CODE_ENUM FUEL_MGR_eGetFuelType(
    SMS_OBJECT hOwner,
    UN8 un8FuelType,
    FUEL_TEXT_STRUCT *psFuelText
        );

#endif /* FUEL_MGR_OBJ_H_ */
