/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:FORECAST header file.
 *
 ******************************************************************************/

#ifndef FORECAST_OBJ_H_
#define FORECAST_OBJ_H_


#include "sms_api.h"
#include "weather_interface.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/


  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/


  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

FORECAST_OBJECT FORECAST_hCreate(
	SMS_OBJECT hParent,
	FORECAST_DATA_STRUCT *psData,
	UN32 un32TimeStamp
		);

void FORECAST_vDestroy (
	FORECAST_OBJECT hForecast
        );

void FORECAST_vUpdateTimeStamp (
	FORECAST_OBJECT hForecast
        );

WEATHER_HASH_OBJECT FORECAST_hHashEntry (
	FORECAST_OBJECT hForecast
        );

BOOLEAN FORECAST_bUpdateHashEntry(
	FORECAST_OBJECT hForecast,
	WEATHER_HASH_OBJECT hNewHashEntry
		);

BOOLEAN FORECAST_bCompareData (
	FORECAST_OBJECT hForecast,
	FORECAST_DATA_STRUCT *psForecastData
        );

UN32 FORECAST_un32Count( void );

#endif /* FORECAST_OBJ_H_ */
