/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:TOPIC header file.
 *
 ******************************************************************************/

#ifndef EPG_TOPIC_OBJ_H_
#define EPG_TOPIC_OBJ_H_

#include "standard.h"
#include "sms_api.h"


  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
#define EPG_TOPIC_NAME_LEN_MAX 184

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
/* Private object elements */

typedef struct epg_topic_struct {
    TOPIC_ID tTopicId;
    STRING_OBJECT hTopicName;
} EPG_TOPIC_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

EPG_TOPIC_STRUCT *EPG_TOPIC_psCreate(SMS_OBJECT hParent,
                                     TOPIC_ID tTopicId,
                                     char *pcTopicName);

void EPG_TOPIC_vDestroy(EPG_TOPIC_STRUCT *psEpgTopic);

N16 EPG_TOPIC_n16CompareEpgTopicsByTid(EPG_TOPIC_STRUCT *psTopic1,
                                       EPG_TOPIC_STRUCT *psTopic2);

N16 EPG_TOPIC_n16CompareEpgTopicAndTid(EPG_TOPIC_STRUCT *psTopic,
                                       TOPIC_ID *ptTopicId);

#endif /* EPG_TOPIC_OBJ_H_ */
