/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:EPG_TEXT_CACHE header file.
 *
 ******************************************************************************/

#ifndef EPG_CACHE_OBJ_H_
#define EPG_CACHE_OBJ_H_

#include "standard.h"
#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

/* Text data related definitions */
typedef struct epg_text_index_item_struct
{
    UN32 un32Offset;
    UN32 un32Size;

} EPG_TEXT_INDEX_ITEM_STRUCT;

typedef struct epg_segment_text_data_struct
{
    UN32 un32DecompressedFileSize;
    UN32 un32CompressedFileSize;

    char *pcDecompressedText;
    UN16 un16NumStrings;
    EPG_TEXT_INDEX_ITEM_STRUCT *asTextIndex; // Dynamic array (size = un16NumStrings)

} EPG_SEGMENT_TEXT_DATA_STRUCT;

typedef struct epg_text_cache_struct
{
    // Maximum allowed number of segments to be cached simulteniously.
    // When cache is full upon trying to cache a segment,
    // cache of segment with the highest index is deleted.
    UN8 un8NumCachedMax;
    // Number of currently cached segments
    UN8 un8NumCached;
    // Size of asTextCacheData array
    UN8 un8NumSegments;
    // Dynamic array of segments' text data (un8NumSegments)
    EPG_SEGMENT_TEXT_DATA_STRUCT *asTextCacheData;

} EPG_TEXT_CACHE_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

EPG_TEXT_CACHE_STRUCT *EPG_TEXT_CACHE_psCreate(SMS_OBJECT hParent,
                                                UN8 un8NumSegments,
                                                UN8 un8NumCachedMax);

void EPG_TEXT_CACHE_vDestroy(EPG_TEXT_CACHE_STRUCT *psCacheObj);

BOOLEAN EPG_TEXT_CACHE_bLoadCompressedTextFile(EPG_TEXT_CACHE_STRUCT *psCacheObj,
                                               UN8 un8SegNum,
                                               FILE *pFile,
                                               UN32 un32CompressedSize,
                                               UN32 un32DecompressedSize);

BOOLEAN EPG_TEXT_CACHE_bGetString(EPG_TEXT_CACHE_STRUCT *psCacheObj,
                                  UN8 un8SegNum,
                                  UN32 un32StringIndex,
                                  STRING_OBJECT hResultString);

void EPG_TEXT_CACHE_vCleanSegment(EPG_TEXT_CACHE_STRUCT *psCacheObj,
                                  UN8 un8SegNum);

void EPG_TEXT_CACHE_vCleanWholeCache(EPG_TEXT_CACHE_STRUCT *psCacheObj);

BOOLEAN EPG_TEXT_CACHE_bIsSegmentCached(EPG_TEXT_CACHE_STRUCT *psCacheObj,
                                        UN8 un8SegNum);

BOOLEAN EPG_TEXT_CACHE_bAppendCompressedTextDataToFile(EPG_TEXT_CACHE_STRUCT *psCacheObj,
                                                       UN8 un8SegNum);

#endif /* EPG_CACHE_OBJ_H_ */
