/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:DSRL header file.
 *
 ******************************************************************************/

#ifndef DSRL_H_
#define DSRL_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// All possible DSRL types
typedef enum dsrl_type_enum
{
    DSRL_TYPE_STANDARD,
    DSRL_TYPE_DEVICE,
    DSRL_TYPE_FAVORITES,
    DSRL_MAX_TYPES

} DSRL_TYPE_ENUM;

// The types of actions to perform
// on a DSRL
typedef enum dsrl_action_enum
{
    DSRL_ACTION_ADD = 0,
    DSRL_ACTION_MODIFY,
    DSRL_ACTION_REMOVE,
    DSRL_ACTION_REFRESH,
    DSRL_ACTION_INVALID

} DSRL_ACTION_ENUM;

// Structure containing information pertinent
// to the modify operation
typedef struct dsrl_modify_struct
{
    // Action Type for the modify operation
    BOOLEAN bForceDSRLStateChange;
    DSRL_MODIFY_OPERATION_ENUM eModifyType;

} DSRL_MODIFY_STRUCT;

// Union to group all types of action
// data in a convenient manner
typedef union dsrl_action_data_union
{
    DSRL_MODIFY_STRUCT sModify;

} DSRL_ACTION_DATA_UNION;

// The types of actions to perform
typedef enum dsrl_add_replace_result_enum
{
    DSRL_ADD_REPLACE_OK = 0,
    DSRL_ADD_REPLACE_NOP,
    DSRL_ADD_REPLACE_ERROR

} DSRL_ADD_REPLACE_RESULT_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/
typedef struct dsrl_arg_struct
{
    DSRL_ACTION_ENUM eAction;
    DSRL_ACTION_DATA_UNION uAction;
    DSRL_OBJECT hDSRL;
    DSRL_TYPE_ENUM eDSRLType;
    size_t tNumTargets;
    DSRL_TARGET_OBJECT ahTargetList[1];

} DSRL_ARG_STRUCT;

typedef DSRL_ENTRY_OBJECT (*DSRL_COMPLETE_ADD_FUNCTION) (
    DSRL_OBJECT hDSRL,
    DSRL_ENTRY_OBJECT hObject,
    void *pvFinalizeArg
        );

typedef void (*DSRL_FINALIZE_FUNCTION) (
    DSRL_OBJECT hDSRL,
    DSRL_ENTRY_OBJECT hEntry,
    void *pvFinalizeArg
        );

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
void DSRL_vDestroy (
    DSRL_OBJECT hDSRL
        );

BOOLEAN DSRL_bSetDefaultSortFunction (
    DSRL_OBJECT hDSRL,
    DSRL_SORT_FUNCTION n16Sort,
    void *pvSortArgs
        );

BOOLEAN DSRL_bSort (
    DSRL_OBJECT hDSRL
        );

BOOLEAN DSRL_bSetCompleteAddFunction (
    DSRL_OBJECT hDSRL,
    DSRL_COMPLETE_ADD_FUNCTION hCompleteAdd,
    void *pvCompleteAddArgs
        );

BOOLEAN DSRL_bSetFinalizeFunction(
    DSRL_OBJECT hDSRL,
    DSRL_FINALIZE_FUNCTION vFinalize,
    void *pvFinalizeArgs
        );

BOOLEAN DSRL_bSetDeviceLocation (
    DSRL_OBJECT hDSRL,
    LOCATION_OBJECT hDeviceLocation
        );

DSRL_ADD_REPLACE_RESULT_ENUM DSRL_eAddEntry (
    DSRL_OBJECT hDSRL,
    DSRL_ENTRY_OBJECT hObject
        );

DSRL_ADD_REPLACE_RESULT_ENUM DSRL_eUpdateEntry (
    DSRL_OBJECT hDSRL,
    DSRL_ENTRY_OBJECT hEntryData
        );

DSRL_ADD_REPLACE_RESULT_ENUM DSRL_eReplaceEntry (
    DSRL_OBJECT hDSRL,
    DSRL_ENTRY_OBJECT hOldEntryData,
    DSRL_ENTRY_OBJECT hNewEntryData
        );

void DSRL_vRemoveEntry (
    DSRL_OBJECT hDSRL,
    DSRL_ENTRY_OBJECT hObject
        );

void DSRL_vRemoveAllEntries (
    DSRL_OBJECT hDSRL
        );

void DSRL_vSetState (
    DSRL_OBJECT hDSRL,
    DSRL_STATE_ENUM eState
        );

void DSRL_vSetType (
    DSRL_OBJECT hDSRL,
    DATASERVICE_TYPE_ENUM eType
        );

void DSRL_vTargetsUpdated (
    DSRL_OBJECT hDSRL
        );

SMSAPI_RETURN_CODE_ENUM DSRL_eIterate (
    DSRL_OBJECT hDSRL,
    DSRL_ITERATOR_CALLBACK bEntryIterator,
    void *pvIteratorArg
        );

DSRL_ARG_STRUCT *DSRL_psCreateArg (
    size_t tNumTargets
        );

void DSRL_vDestroyArg (
    DSRL_ARG_STRUCT *psArg
        );

void *DSRL_pvServiceData (
    DSRL_OBJECT hDSRL
        );

#endif /* DSRL_H_ */

