/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PUBLIC HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef DS_UTIL_H_
#define DS_UTIL_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"
#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Common useful constants
#define BITS_IN_BYTE        (8)
#define SECONDS_IN_MINUTE   (60)
#define MINUTES_IN_HOUR     (60)
#define HOURS_IN_DAY        (24)
#define SECONDS_IN_HOUR     (SECONDS_IN_MINUTE * MINUTES_IN_HOUR)
#define SECONDS_IN_DAY      (SECONDS_IN_HOUR * HOURS_IN_DAY)

#define DS_UTIL_AU_CRC_INVERSION_VALUE          (0xFFFFFFFFL)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

// Parsing helpers
BOOLEAN DS_UTIL_bExtractBitField (
    UN32 *pun32Value,
    OSAL_BUFFER_HDL hPayload,
    UN8 un8FieldBitLen
        );

BOOLEAN DS_UTIL_bExtractOptionalBitField (
    UN32 *pun32Value,
    OSAL_BUFFER_HDL hPayload,
    UN8 un8FieldBitLen,
    UN32 un32DefaultValue
        );

BOOLEAN DS_UTIL_bExtractBytes (
    void *pDst,
    OSAL_BUFFER_HDL hPayload,
    size_t tSize
        );

BOOLEAN DS_UTIL_bCopyPayload (
    OSAL_BUFFER_HDL hPayload,
    void *pvDst,
    size_t *ptDataSize
        );

void *DS_UTIL_pvCopyPayload (
    OSAL_BUFFER_HDL hPayload,
    size_t *ptDataSize
        );

BOOLEAN DS_UTIL_bCutCRC (
    OSAL_BUFFER_HDL hPayload
        );

BOOLEAN DS_UTIL_bIsCRCValid (
    OSAL_OBJECT_HDL hCRC,
    OSAL_BUFFER_HDL hPayload,
    OSAL_CRC_RESULT *ptCalculatedCrc
        );

// File management helpers
BOOLEAN DS_UTIL_bCopyFile (
    char *pcSrcFilePath,
    char *pcDstFilePath,
    BOOLEAN bReplace,
    BOOLEAN bRename
        );

#endif /* DS_UTIL_H_ */
