/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This module contains the Object:detailed overlay signal quality
 *  implementation for the Sirius Module Services (SMS)
 *
 ******************************************************************************/
#include <string.h>
#include "sms_obj.h"
#include "engineering_data_obj.h"
#include "_detailed_overlay_signal_quality_obj.h"
#include "detailed_overlay_signal_quality_obj.h"

#include "sms_api_debug.h"

static const char *gpacThisFile = __FILE__;

/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   hReceiverState
*
******************************************************************************/
static STRING_OBJECT hReceiverState (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hReceiverState;
    }

    return hReturnString;
}



/*****************************************************************************
*
*   hOBERS1A
*
*****************************************************************************/
static STRING_OBJECT hOBERS1A (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERS1A;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERS1B
*
*****************************************************************************/
static STRING_OBJECT hOBERS1B (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERS1B;
    }

    return hReturnString;
}

/*****************************************************************************
*
*   hOBERS2A
*
*****************************************************************************/
static STRING_OBJECT hOBERS2A (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERS2A;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERS2B
*
*****************************************************************************/
static STRING_OBJECT hOBERS2B (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERS2B;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERTerrA
*
*****************************************************************************/
static STRING_OBJECT hOBERTerrA (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTerrA;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERTerrB
*
*****************************************************************************/
static STRING_OBJECT hOBERTerrB (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTerrB;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERTurboWordErrRate0A
*
*****************************************************************************/
static STRING_OBJECT hOBERTurboWordErrRate0A (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTurboWordErrRate0A;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERTurboWordErrRate1A
*
*****************************************************************************/
static STRING_OBJECT hOBERTurboWordErrRate1A (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTurboWordErrRate1A;
    }

    return hReturnString;
}

/*****************************************************************************
*
*   hOBERTurboWordErrRate2A
*
*****************************************************************************/
static STRING_OBJECT hOBERTurboWordErrRate2A (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTurboWordErrRate2A;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERTurboWordErrRate0B
*
*****************************************************************************/
static STRING_OBJECT hOBERTurboWordErrRate0B (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTurboWordErrRate0B;
    }

    return hReturnString;
}

/*****************************************************************************
*
*   hOBERTurboWordErrRate1B
*
*****************************************************************************/
static STRING_OBJECT hOBERTurboWordErrRate1B (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTurboWordErrRate1B;
    }

    return hReturnString;
}


/*****************************************************************************
*
*   hOBERTurboWordErrRate2B
*
*****************************************************************************/
static STRING_OBJECT hOBERTurboWordErrRate2B (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
            )
{
    BOOLEAN bOwner;
    STRING_OBJECT hReturnString = STRING_INVALID_OBJECT;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
        psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                    hDetOverlaySigQuality;
        hReturnString = psObj->hOBERTurboWordErrRate2B;
    }

    return hReturnString;
}

/*****************************************************************************
*
*   n32FPrintf
*
*****************************************************************************/
static N32 n32FPrintf (
        DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality,
        FILE *psFile
            )
{
    N32 n32Return = 0;
    BOOLEAN bOwner;

    if ( ( psFile == NULL ) ||
         ( hDetOverlaySigQuality ==
                DETAILED_OVERLAY_SIGNAL_QUALITY_INVALID_OBJECT ))
    {
        return EOF;
    }

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetOverlaySigQuality);
    if ( bOwner == TRUE )
    {
        STRING_OBJECT hStr;

        n32Return += fprintf(psFile,
                            "DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT\n");

         //ReceiverrState
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hReceiverState(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "ReceiverState=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //hOBERS1A
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERS1A(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERS1A=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERS1B
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERS1B(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERS1B=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERS2A
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERS2A(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERS2A=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERS2B
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERS2B(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERS2B=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERTerrA
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTerrA(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTerrA=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }


        //OBERTerrB
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTerrB(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTerrB=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERTurboWordErrRate0A
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTurboWordErrRate0A(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTurboWordErrRate0A=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERTurboWordErrRate1A
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTurboWordErrRate1A(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTurboWordErrRate1A=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERTurboWordErrRate2A
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTurboWordErrRate2A(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTurboWordErrRate2A=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERTurboWordErrRate0B
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTurboWordErrRate0B(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTurboWordErrRate0B=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERTurboWordErrRate1B
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTurboWordErrRate1B(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTurboWordErrRate1B=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }

        //OBERTurboWordErrRate2B
        hStr = DETAILED_OVERLAY_SIGNAL_QUALITY.hOBERTurboWordErrRate2B(
                                                    hDetOverlaySigQuality);
        if ( hStr !=STRING_INVALID_OBJECT )
        {
            n32Return += fprintf(psFile, "OBERTurboWordErrRate2B=%s\n",
                STRING.pacCStr(hStr));
        }
        else
        {
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Invalid STRING_OBJECT");
        }
    }
    else
    {
        SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
	            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
	            ": Not owner");
	    return EOF;

    }
    return n32Return;
}

/*****************************************************************************
                             FRIEND FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   DETAILED_OVERLAY_SIGNAL_QUALITY_bUpdateDetailedOverlaySignalQuality
*
*****************************************************************************/
BOOLEAN DETAILED_OVERLAY_SIGNAL_QUALITY_bUpdateDetailedOverlaySignalQuality(
    DECODER_OBJECT hDecoder,
    DETAILED_OVERLAY_SIGNAL_QUALITY_STRUCT const *psDetailedOverlaySignalQuality
        )
{
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
    BOOLEAN bReturn = FALSE;
    SMSAPI_RETURN_CODE_ENUM eReturn;
    BOOLEAN bFirstUpdateReceived;

    if ( hDecoder == DECODER_INVALID_OBJECT )
    {
        SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
                    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
                    ": Invalid DECODER_OBJECT");
        return bReturn;
    }

    eReturn = eAccessObjectFromDecoder(hDecoder,
                    (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT **)&psObj);

    if ( eReturn != SMSAPI_RETURN_CODE_SUCCESS )
    {
        SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
                    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
                    ": Unable to access DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT");
        return bReturn;
    }

    bFirstUpdateReceived = psObj->bFirstUpdateReceived;

    //Determine if any values have changed and update those values
    if (  ( psObj->sCurrentOverlaySignalQuality.un16OberS1A
          != psDetailedOverlaySignalQuality->un16OberS1A
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERS1A,
                    psDetailedOverlaySignalQuality->un16OberS1A);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16OberS1B
          != psDetailedOverlaySignalQuality->un16OberS1B
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERS1B,
                    psDetailedOverlaySignalQuality->un16OberS1B);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16OberS2A
          != psDetailedOverlaySignalQuality->un16OberS2A
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERS2A,
                    psDetailedOverlaySignalQuality->un16OberS2A);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16OberS2B
          != psDetailedOverlaySignalQuality->un16OberS2B
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERS2B,
                    psDetailedOverlaySignalQuality->un16OberS2B);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16OberTA
          != psDetailedOverlaySignalQuality->un16OberTA
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTerrA,
                    psDetailedOverlaySignalQuality->un16OberTA);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16OberTB
          != psDetailedOverlaySignalQuality->un16OberTB
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTerrB,
                    psDetailedOverlaySignalQuality->un16OberTB);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16TurboWordErrorRate0A
          != psDetailedOverlaySignalQuality->un16TurboWordErrorRate0A
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTurboWordErrRate0A,
                    psDetailedOverlaySignalQuality->un16TurboWordErrorRate0A);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16TurboWordErrorRate0B
          != psDetailedOverlaySignalQuality->un16TurboWordErrorRate0B
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTurboWordErrRate0B,
                    psDetailedOverlaySignalQuality->un16TurboWordErrorRate0B);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16TurboWordErrorRate1A
          != psDetailedOverlaySignalQuality->un16TurboWordErrorRate1A
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTurboWordErrRate1A,
                    psDetailedOverlaySignalQuality->un16TurboWordErrorRate1A);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16TurboWordErrorRate1B
          != psDetailedOverlaySignalQuality->un16TurboWordErrorRate1B
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTurboWordErrRate1B,
                    psDetailedOverlaySignalQuality->un16TurboWordErrorRate1B);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16TurboWordErrorRate2A
          != psDetailedOverlaySignalQuality->un16TurboWordErrorRate2A
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTurboWordErrRate2A,
                    psDetailedOverlaySignalQuality->un16TurboWordErrorRate2A);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un16TurboWordErrorRate2B
          != psDetailedOverlaySignalQuality->un16TurboWordErrorRate2B
          )
       || ( bFirstUpdateReceived == FALSE )
       )
    {
        vPercentStringModify(psObj->hOBERTurboWordErrRate2B,
                    psDetailedOverlaySignalQuality->un16TurboWordErrorRate2B);
        bReturn = TRUE;
    }

    if (  ( psObj->sCurrentOverlaySignalQuality.un8ReceiverState
          != psDetailedOverlaySignalQuality->un8ReceiverState
          )
       || (  bFirstUpdateReceived == FALSE )
       )
    {
        char pStr[MAX_STRING_SIZE];
        snprintf(pStr, BYTEFIELD_SIZE, "x%02x",
                    psDetailedOverlaySignalQuality->un8ReceiverState);
        STRING.bModifyCStr(psObj->hReceiverState, pStr);
        bReturn = TRUE;
    }

    psObj->bFirstUpdateReceived = TRUE;
    psObj->sCurrentOverlaySignalQuality = *psDetailedOverlaySignalQuality;
    return bReturn;
}

/*****************************************************************************
*
*   DETAILED_OVERLAY_SIGNAL_QUALITY_vInitializeObject
*
*****************************************************************************/
void DETAILED_OVERLAY_SIGNAL_QUALITY_vInitializeObject(
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetailedOverlaySignalQuality
        )
{
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner;

    psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                hDetailedOverlaySignalQuality;

    bOwner = SMSO_bOwner((SMS_OBJECT)hDetailedOverlaySignalQuality);
 	if( bOwner == FALSE )
 	{
        // Error!
 	    return;
 	}

    vReleaseStrings(hDetailedOverlaySignalQuality);

    // Initialize state attributes
    *psObj = gsObjectDefaults;

    //Create strings and set values to one obviously not from decoder.
    psObj->hOBERS1A =
        STRING_hCreate((SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERS1B =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERS2A =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERS2B =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTerrA =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTerrB =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTurboWordErrRate0A =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTurboWordErrRate1A =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTurboWordErrRate2A =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTurboWordErrRate0B =
         STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTurboWordErrRate1B =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hOBERTurboWordErrRate2B =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_4,
                        PERCENT_SIZE, PERCENT_SIZE);
    psObj->hReceiverState =
        STRING_hCreate( (SMS_OBJECT)psObj, INVALID_3,
                        BYTEFIELD_SIZE, BYTEFIELD_SIZE);
    return;
}

/*****************************************************************************
*
*   DETAILED_OVERLAY_SIGNAL_QUALITY_hCreate
*
*****************************************************************************/
DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT DETAILED_OVERLAY_SIGNAL_QUALITY_hCreate(
    ENGINEERING_DATA_OBJECT hOwner
        )
{
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;
    BOOLEAN bOwner;

    // Verify ownership of parent object
    bOwner = SMSO_bOwner((SMS_OBJECT)hOwner);

    if ( bOwner == FALSE )
    {
        return DETAILED_OVERLAY_SIGNAL_QUALITY_INVALID_OBJECT;
    }

    // Create an instance of this object
    psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
         SMSO_hCreate(
            DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME,
            sizeof(DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT),
            (SMS_OBJECT)hOwner, FALSE);

    if( psObj == NULL )
    {
        // Error!
        return DETAILED_OVERLAY_SIGNAL_QUALITY_INVALID_OBJECT;
    }

    DETAILED_OVERLAY_SIGNAL_QUALITY_vInitializeObject(
        (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT) psObj);


    if (   ( psObj->hOBERS1A == STRING_INVALID_OBJECT )
        || ( psObj->hOBERS1B == STRING_INVALID_OBJECT )
        || ( psObj->hOBERS2A == STRING_INVALID_OBJECT )
        || ( psObj->hOBERS2B == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTerrA == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTerrB == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTurboWordErrRate0A == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTurboWordErrRate1A == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTurboWordErrRate2A == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTurboWordErrRate0B == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTurboWordErrRate1B == STRING_INVALID_OBJECT )
        || ( psObj->hOBERTurboWordErrRate2B == STRING_INVALID_OBJECT )
        || ( psObj->hReceiverState == STRING_INVALID_OBJECT )
       )
    {
        SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
                    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
                    ": Unable to create a DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT component");
        DETAILED_OVERLAY_SIGNAL_QUALITY_vDestroy(
                    (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT)psObj);
        return DETAILED_OVERLAY_SIGNAL_QUALITY_INVALID_OBJECT;
    }

    psObj->bFirstUpdateReceived = FALSE;
   	return (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT)psObj;
}

/*****************************************************************************
*
*   DETAILED_OVERLAY_SIGNAL_QUALITY_vDestroy
*
*****************************************************************************/
void DETAILED_OVERLAY_SIGNAL_QUALITY_vDestroy (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetailedOverlaySignalQuality
        )
{
    BOOLEAN bOwner;

 	bOwner = SMSO_bOwner((SMS_OBJECT)hDetailedOverlaySignalQuality);
 	if( bOwner == FALSE )
 	{
        // Error!
 	    return;
 	}

    //Free Object Strings
    vReleaseStrings(hDetailedOverlaySignalQuality);

    // Free object instance
    SMSO_vDestroy((SMS_OBJECT)hDetailedOverlaySignalQuality);
    return;
}

/*****************************************************************************
                             PRIVATE FUNCTIONS
*****************************************************************************/
/*****************************************************************************
*
*   vPercentStringModify
*
*****************************************************************************/
static void vPercentStringModify(
    STRING_OBJECT hStrTargetObj,
    UN16 un16PercentValue
        )
{
    char pStr[MAX_STRING_SIZE];

    //undocumented feature in SXi....
    if ( un16PercentValue == NO_ACTIVE_PIPE )
    {
        snprintf(pStr, PERCENT_SIZE, NO_ACTIVE_PIPE_STR);
        STRING.bModifyCStr(hStrTargetObj, pStr);
    }
    else
    {
        UN16 un16PercentInteger;
        UN16 un16PercentFraction;

        un16PercentInteger = un16PercentValue/DECIMAL_BASE;
        un16PercentFraction = un16PercentValue%DECIMAL_BASE;

        //Special formatting for 100%
        if ( un16PercentInteger == MAX_PERCENT )
        {
            snprintf(pStr, PERCENT_SIZE,"%u ",MAX_PERCENT);
            STRING.bModifyCStr(hStrTargetObj, pStr);
        }
               //Convert to xx.x format
        else if ( un16PercentInteger < MAX_PERCENT )
        {
            snprintf( pStr, PERCENT_SIZE, "%02u.%01u",
                      un16PercentInteger,
                      un16PercentFraction );
            STRING.bModifyCStr(hStrTargetObj, pStr);
        }
        else
        {
            snprintf(pStr, PERCENT_SIZE, INVALID_4);
            SMSAPI_DEBUG_vPrintErrorFull(gpacThisFile, __LINE__,
                    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME
                    ": Invalid percentage received.");
        }
    }
}

/*****************************************************************************
*
*   eAccessObjectFromDecoder
*
*****************************************************************************/
static SMSAPI_RETURN_CODE_ENUM eAccessObjectFromDecoder(
    DECODER_OBJECT hDecoder,
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT **ppsObj
        )
{
    BOOLEAN bOwner;
    SMSAPI_RETURN_CODE_ENUM eReturnCode = SMSAPI_RETURN_CODE_INVALID_INPUT;

    // Verify caller is already the owner of the object.
    // If not this function may not be called.
    bOwner = SMSO_bOwner((SMS_OBJECT)hDecoder);
    if( bOwner == TRUE )
    {
        do
        {
            *ppsObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                        ENGINEERING_DATA.hOverlaySignalQualityDetailed(
                                         hDecoder);

            if( *ppsObj == NULL )
            {
                eReturnCode = SMSAPI_RETURN_CODE_NOT_FOUND;
                break;
            }

            // If we made it this far all is well
            eReturnCode = SMSAPI_RETURN_CODE_SUCCESS;

        } while(0);
    }
    else
    {
        eReturnCode = SMSAPI_RETURN_CODE_NOT_OWNER;
    }

    return eReturnCode;
}

/*****************************************************************************
*
*   vReleaseStrings
*
*****************************************************************************/
static void vReleaseStrings(
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetailedOverlaySignalQuality
        )
{
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *psObj;

    psObj = (DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT *)
                hDetailedOverlaySignalQuality;

    //Free Object Strings
    if(psObj->hOBERS1A != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERS1A);
        psObj->hOBERS1A = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERS1B != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERS1B);
        psObj->hOBERS1B = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERS2A != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERS2A);
        psObj->hOBERS2A = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERS2B != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERS2B);
        psObj->hOBERS2B = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTerrA != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTerrA);
        psObj->hOBERTerrA = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTerrB != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTerrB);
        psObj->hOBERTerrB = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTurboWordErrRate0A != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTurboWordErrRate0A);
        psObj->hOBERTurboWordErrRate0A = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTurboWordErrRate1A != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTurboWordErrRate1A);
        psObj->hOBERTurboWordErrRate1A = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTurboWordErrRate2A != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTurboWordErrRate2A);
        psObj->hOBERTurboWordErrRate2A = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTurboWordErrRate0B != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTurboWordErrRate0B);
        psObj->hOBERTurboWordErrRate0B = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTurboWordErrRate1B != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTurboWordErrRate1B);
        psObj->hOBERTurboWordErrRate1B = STRING_INVALID_OBJECT;
    }

    if(psObj->hOBERTurboWordErrRate2B != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hOBERTurboWordErrRate2B);
        psObj->hOBERTurboWordErrRate2B = STRING_INVALID_OBJECT;
    }

    if(psObj->hReceiverState != STRING_INVALID_OBJECT)
    {
        STRING_vDestroy(psObj->hReceiverState);
        psObj->hReceiverState = STRING_INVALID_OBJECT;
    }

    return;
}
