/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:Decoder header file.
 *
 ******************************************************************************/

#ifndef DECODER_OBJ_H_
#define DECODER_OBJ_H_

#include <time.h>

#include "standard.h"

#include "sti_api.h"
#include "sms_api.h"
#include "ccache.h"
#include "sms_event.h"
#include "sms.h"
#include "scache.h"
#include "browse_obj.h"
#include "cme.h"
#include "radio.h"
#include "tag_obj.h"
#include "channel_art_mgr_obj.h"
#include "engineering_data_obj.h"
#include "detailed_signal_quality_obj.h"
#include "detailed_overlay_signal_quality_obj.h"
#include "link_status_information_obj.h"
#include "smart_favorites_obj.h"
#include "tunemix_obj.h"
#include "sports_flash_obj.h"
#include "tw_now_obj.h"

// If logging hasn't been configured already
// then only enable when we're in debug
#ifndef SMS_LOGGING
#if SMS_DEBUG == 1
#define SMS_LOGGING 1
#else
#define SMS_LOGGING 0
#endif
#endif

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef enum channel_map_state_enum
{
    CHANNEL_MAP_STATE_UNKNOWN,
    CHANNEL_MAP_STATE_CHANGING,
    CHANNEL_MAP_STATE_NOT_CHANGING

} CHANNEL_MAP_STATE_ENUM;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BOOLEAN DECODER_bRelease(
    DECODER_OBJECT hDecoder,
    SMS_OBJECT_RELEASE_INITIATOR_ENUM eInitiator
        );

DECODER_STATE_ENUM DECODER_eState(
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bAssociate (
    DECODER_OBJECT hDecoder,
    MODULE_OBJECT hModule,
    STI_HDL hSTI
        );

BOOLEAN DECODER_bUnassociate (
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bFeaturedFavorites(
    DECODER_OBJECT hDecoder,
    SMS_EVENT_FEATURED_FAVORITES_STRUCT const *psEvent
        );

BOOLEAN DECODER_bSmartFavorites (
    DECODER_OBJECT hDecoder,
    SMS_EVENT_SMART_FAVORITES_STRUCT *psEventData
        );

BOOLEAN DECODER_bSetError (
    DECODER_OBJECT hDecoder,
    DECODER_ERROR_CODE_ENUM eErrorCode
        );

MODULE_OBJECT DECODER_hModule (
    DECODER_OBJECT hDecoder
        );

CCACHE_OBJECT DECODER_hCCache (
    DECODER_OBJECT hDecoder
        );

SMART_FAVORITES_OBJECT DECODER_hGetSmartFavoritesHandle (
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bSetSmartFavoritesHandle (
    DECODER_OBJECT hDecoder,
    SMART_FAVORITES_OBJECT hSmartFavorites,
    CATEGORY_ID tCategoryId
        );

CME_OBJECT DECODER_hCME (
    DECODER_OBJECT hDecoder
        );

SMS_EVENT_HDL DECODER_hAllocateEvent(
    DECODER_OBJECT hDecoder,
    SMS_EVENT_TYPE_ENUM eEvent,
    EVENT_OPTIONS_TYPE tOptions,
    SMS_EVENT_DATA_UNION ** ppuEventData
        );

void DECODER_vPlaybackEvent (
    DECODER_OBJECT hDecoder,
    SMSAPI_EVENT_MASK tEventMask
        );

BOOLEAN DECODER_bPlayPause (
    DECODER_OBJECT hDecoder,
    BOOLEAN bPause
        );

BOOLEAN DECODER_bSeekTime (
    DECODER_OBJECT hDecoder,
    N32 n32Seconds,
    BOOLEAN bPauseAfterSeek
        );

BOOLEAN DECODER_bSeekSong (
    DECODER_OBJECT hDecoder,
    N16 n16RelativeOffset,
    BOOLEAN bPauseAfterSeek
        );

BOOLEAN DECODER_bSeekPrevious(
    DECODER_OBJECT hDecoder, BOOLEAN bPauseAfterSeek
        );

BOOLEAN DECODER_bSeekNext(
    DECODER_OBJECT hDecoder, BOOLEAN bPauseAfterSeek
        );

void DECODER_vCreateSongList (
    DECODER_OBJECT hDecoder,
    SONGLIST_OBJECT hSonglist
        );

void DECODER_vDestroySongList (
    DECODER_OBJECT hDecoder,
    SONGLIST_OBJECT hSonglist
        );

void DECODER_vSeekAlertEvent (
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bSetSeekServiceHandle (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    SEEK_SERVICE_OBJECT hSeekService
        );

SMSAPI_RETURN_CODE_ENUM DECODER_eSeekService(
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    SEEK_SERVICE_OBJECT *phSeekService
        );

BOOLEAN DECODER_bSetSportZoneServiceHandle(
    DECODER_OBJECT hDecoder,
    SPORT_ZONE_SERVICE_OBJECT hService
        );

SPORT_ZONE_SERVICE_OBJECT DECODER_hSportZoneService(
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bSetSubNotificationServiceHandle(
    DECODER_OBJECT hDecoder,
    SUB_NOTIFICATION_OBJECT hService);

SUB_NOTIFICATION_OBJECT DECODER_hSubscriptionService(
    DECODER_OBJECT hDecoder);

SMSAPI_RETURN_CODE_ENUM DECODER_eSetSubscriptionAlertText(
    DECODER_OBJECT hDecoder, const char *pacSubAlertArtistText,
    const char *pacSubAlertTitleText);

BOOLEAN DECODER_bSetPresetsHandle (
    DECODER_OBJECT hDecoder,
    PRESETS_OBJECT hPresets
        );

PRESETS_OBJECT DECODER_hPresets (
    DECODER_OBJECT hDecoder
        );

void DECODER_vGenericUpdateEventMask(
    DECODER_OBJECT hDecoder,
    SMSAPI_EVENT_MASK tEventMask
        );

const char *DECODER_pacName(
    DECODER_OBJECT hDecoder
        );

TAG_OBJECT DECODER_hGetTag(
    DECODER_OBJECT hDecoder
        );

TAG_OBJECT DECODER_hGetTag(
    DECODER_OBJECT hDecoder
        );

#if SMS_LOGGING == 1
void DECODER_vLog (
    DECODER_OBJECT hDecoder,
    const char *pcFormat,
    ...
        );
#else
#if __STDC_VERSION__ >= 199901L
#define DECODER_vLog(...)
#else
void DECODER_vLogNothing(
    DECODER_OBJECT hDecoder,
    const char *pcFormat,
    ...
        );
#define DECODER_vLog if(1);else DECODER_vLogNothing
#endif
#endif

void DECODER_vUpdateSignal (
    DECODER_OBJECT hDecoder,
    const SIGNAL_QUALITY_STRUCT *psSignalQuality
        );

void DECODER_vUpdateAudioDecoderBitRate (
    DECODER_OBJECT hDecoder,
    AUDIO_DECODER_BITRATE tBitrate
        );

void DECODER_vUpdateDetailedSignalQuality(
    DECODER_OBJECT hDecoder,
    DETAILED_SIGNAL_QUALITY_STRUCT const *psNewDetailedSignalQuality
        );

void DECODER_vUpdateDetailedOverlaySignalQuality(
    DECODER_OBJECT hDecoder,
    DETAILED_OVERLAY_SIGNAL_QUALITY_STRUCT const *psNewDetailedOverlaySignalQuality
        );

void DECODER_vUpdateLinkStatusInformation(
    DECODER_OBJECT hDecoder,
    LINK_INFORMATION_STRUCT const *psNewLinkStatusInformation
        );

void DECODER_vUpdateAntennaState (
    DECODER_OBJECT hDecoder,
    N8 n8Antenna,
    ANTENNA_STATE_ENUM eAntennaState
        );

void DECODER_vUpdateProgress (
    DECODER_OBJECT hDecoder,
    UN8 un8UpdateProgress
        );

void DECODER_vUpdateComplete(
    DECODER_OBJECT hDecoder
        );

void DECODER_vUpdateSubscription (
    DECODER_OBJECT hDecoder
        );

void DECODER_vUpdateTunedServiceId (
    DECODER_OBJECT hDecoder,
    SERVICE_ID tTunedServiceId,
    BOOLEAN bNeedToSave
        );

void DECODER_vUpdateTuneScanContentState (
    DECODER_OBJECT hDecoder,
    BOOLEAN bIsAvailable
        );

void DECODER_vUpdateTuneScanTerminateState (
    DECODER_OBJECT hDecoder,
    BOOLEAN bTerminated
        );

BOOLEAN DECODER_bTuneScanActive(
    DECODER_OBJECT hDecoder
        );

SERVICE_ID DECODER_tBrowsedServiceId(
    DECODER_OBJECT hDecoder
        );

SERVICE_ID DECODER_tLastTunedServiceId(
    DECODER_OBJECT hDecoder
        );

void DECODER_vTunedChanNoLongerAvail(
    DECODER_OBJECT hDecoder
        );

void DECODER_vLastTunedChanNoLongerAvail(
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bStartAllChanCatNotifications(
    DECODER_OBJECT hDecoder,
    BOOLEAN bNotifyChannels
        );

void DECODER_vHandleAllChanCatNotificationEvent(
    DECODER_OBJECT hDecoder,
    BOOLEAN bNotifyChannels
        );

BOOLEAN DECODER_bRadioReady (
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bSetRadioSpecificData (
    DECODER_OBJECT hDecoder,
    RADIO_PRIVATE_DATA_OBJECT hData
        );

RADIO_PRIVATE_DATA_OBJECT DECODER_hGetRadioSpecificData (
    DECODER_OBJECT hDecoder
        );

void DECODER_vChannelEventMask(
    CHANNEL_OBJECT hChannel,
    CHANNEL_EVENT_MASK *ptChannelMask
        );

ENGINEERING_DATA_OBJECT DECODER_hGetEngineeringData (
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM DECODER_eModifyChanListRegisteredEventMask (
    DECODER_OBJECT hDecoder,
    CHANNELLIST_OBJECT hChannelList,
    CHANNEL_EVENT_MASK tEventMask,
    SMSAPI_MODIFY_EVENT_MASK_ENUM eModification
        );

SMSAPI_RETURN_CODE_ENUM DECODER_eAlertTone(
    DECODER_OBJECT hDecoder,
    N8 n8Volume
        );

BOOLEAN DECODER_bReset (
    DECODER_OBJECT hDecoder
        );

CHANNEL_OBJECT DECODER_hBrowsedChannel(
    DECODER_OBJECT hDecoder
        );

BROWSE_OBJECT DECODER_hBrowse(
    DECODER_OBJECT hDecoder
        );

void DECODER_vUpdateACO(
    DECODER_OBJECT hDecoder,
    CHANNEL_OBJECT hChannel,
    CHANNEL_ACO tACO
        );

DECODER_EVENT_MASK DECODER_tRequestedEventMask(
    DECODER_OBJECT hDecoder
        );

SMS_EVENT_HDL DECODER_hAllocateCMEUpdateEvent(
    DECODER_OBJECT hDecoder
        );

void DECODER_vSetTuneMix(
    DECODER_OBJECT hDecoder,
    UN8 un8TMIndex,
    TUNEMIX_OBJECT hTuneMix
        );

BOOLEAN DECODER_bGetTuneMixIndexAvailable(
    DECODER_OBJECT hDecoder,
    UN8 *pun8Index,
    CHANNEL_ID *ptTuneMixId
        );

TUNEMIX_OBJECT DECODER_hGetTuneMix(
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tTuneMixId
        );

TUNEMIX_OBJECT DECODER_hGetTuneMixActive(
    DECODER_OBJECT hDecoder
        );

void DECODER_vSetTuneMixActive(
    DECODER_OBJECT hDecoder,
    TUNEMIX_OBJECT hTuneMIx
        );

UN8 DECODER_un8GetMaxTuneMix(
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bIsTuneMixSupported(
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM DECODER_eTuneMixTune(
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tTuneMixId,
    BOOLEAN bOverride,
    BOOLEAN bPlayUnrestricted
        );

SMSAPI_RETURN_CODE_ENUM DECODER_eTuneMixConfigure(
    DECODER_OBJECT hDecoder,
    UN8 un8TuneMixChannelIndex
        );

void DECODER_vTuneMixEvent(
    DECODER_OBJECT hDecoder
        );

CHANNEL_ID DECODER_tTuneMixIdFromIndex(
    DECODER_OBJECT hDecoder,
    UN8 un8Index
        );

SMSAPI_RETURN_CODE_ENUM DECODER_eIterateTuneMixList(
    DECODER_OBJECT hDecoder,
    TUNEMIX_ITERATOR_CALLBACK pbIterator,
    void *pvArg
        );

void DECODER_vSelfTuneFallback (
    DECODER_OBJECT hDecoder,
    SERVICE_ID tServiceId
        );

SPORTS_FLASH_OBJECT DECODER_hSportsFlash(
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bSetSportsFlashHandle (
    DECODER_OBJECT hDecoder,
    SPORTS_FLASH_OBJECT hSportsFlash
        );

BOOLEAN DECODER_bSportsFlash(
    DECODER_OBJECT hDecoder,
    SMS_EVENT_SPORTS_FLASH_STRUCT const *psEvent
        );

BOOLEAN DECODER_bPlayFlashEvent(
    DECODER_OBJECT hDecoder,
    SPORTS_FLASH_EVENT_ID tFlashEventID
        );

BOOLEAN DECODER_bAbortFlashEvent(
    DECODER_OBJECT hDecoder,
    SPORTS_FLASH_EVENT_ID tFlashEventID
        );

BOOLEAN DECODER_bRemainFlashEvent(
    DECODER_OBJECT hDecoder,
    SPORTS_FLASH_EVENT_ID tFlashEventID
        );

TW_NOW_OBJECT DECODER_hGetTWNowHandle (
    DECODER_OBJECT hDecoder
        );

BOOLEAN DECODER_bSetTWNowHandle (
    DECODER_OBJECT hDecoder,
    TW_NOW_OBJECT hTWNow
        );

BOOLEAN DECODER_bTWNow(
    DECODER_OBJECT hDecoder,
    SMS_EVENT_TW_NOW_STRUCT const *psEvent
        );

BOOLEAN DECODER_bTWNowPlayAbort (
    DECODER_OBJECT hDecoder,
    TW_NOW_BULLETIN_ID tBulletinId,
    BOOLEAN bAbort
        );

void DECODER_vUpdateTWNowStatus (
    DECODER_OBJECT hDecoder,
    TW_NOW_BULLETIN_ID tBulletinId,
    BOOLEAN bTunningInProgress
        );

void DECODER_vUpdateAudioPresence (
    DECODER_OBJECT hDecoder,
    DECODER_AUDIO_PRESENCE_ENUM eAudioPresence
        );

#endif /* DECODER_OBJ_H */
