/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:DATASERVICE_MGR header file.
 *
 ******************************************************************************/

#ifndef DATASERVICE_MGR_OBJ_H_
#define DATASERVICE_MGR_OBJ_H_

#include "standard.h"

#include "osal.h"
#include "sms_api.h"
#include "dataservice_base.h"
#include "device_obj.h"
#include "dsrl_obj.h"
#include "tag_obj.h"
#include "sti_api.h"
#include "radio.h"

// If logging hasn't been configured already
// then only enable when we're in debug
#ifndef SMS_LOGGING
#if SMS_DEBUG == 1 && OSAL_LOG == 1
#define SMS_LOGGING 1
#else
#define SMS_LOGGING 0
#endif
#endif

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Is used by the radio module when it wishes
// to iterate through the radio data associated
// with each data service
typedef BOOLEAN (*DATASERVICE_RADIO_DATA_ITERATOR) (
    RADIO_PRIVATE_DATA_OBJECT hRadioData,
    void *pvIteratorArg
        );

typedef struct dataservice_event_timestamp_struct
{
    UN32 un32Sec;
    UN16 un16Msec;

} DATASERVICE_EVENT_TIMESTAMP_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

SMS_OBJECT DATASERVICE_MGR_hInitialize(
    SMS_EVENT_HANDLER *phEventHandler,
    DEVICE_OBJECT *phDeviceObject
        );

void DATASERVICE_MGR_vUnInitialize(
    SMS_OBJECT hDSMCtrl
        );

BOOLEAN DATASERVICE_MGR_bPostDevicePositionEvent (
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon
        );

SMS_EVENT_HDL DATASERVICE_MGR_hAllocateRadioEvent(
    SMS_EVENT_TYPE_ENUM eEvent,
    EVENT_OPTIONS_TYPE tOptions,
    void **ppvEventData
        );

BOOLEAN DATASERVICE_MGR_bPostEvent (
    DATASERVICE_MGR_OBJECT hManager,
    DATASERVICE_FW_EVENT_ENUM eEvent,
    void *pvDataEventArg
        );

void DATASERVICE_MGR_vDSIStateChange (
    DATASERVICE_MGR_OBJECT hManager,
    DSI tDSI,
    DATASERVICE_STATE_ENUM eState
        );

void DATASERVICE_MGR_vReceivePayload (
    DATASERVICE_MGR_OBJECT hManager,
    DSI tDSI,
    OSAL_BUFFER_HDL hPayload
        );

BOOLEAN DATASERVICE_MGR_bAssociateModule (
    const char *pacDriverName,
    MODULE_OBJECT hModule,
    STI_HDL hSTI
        );

void DATASERVICE_MGR_vUnassociateModule (
    MODULE_OBJECT hModule
        );

BOOLEAN DATASERVICE_MGR_bCreateFileBuffer (
    OSAL_OBJECT_HDL *phBlockPool,
    OSAL_BUFFER_HDL *phBuffer,
    size_t tBlockSize
        );

void DATASERVICE_MGR_vDestroyFileBuffer (
    OSAL_OBJECT_HDL hBlockPool,
    OSAL_BUFFER_HDL hBuffer
        );

BOOLEAN DATASERVICE_MGR_bFillBufferBlock (
    FILE *psInputFile,
    OSAL_BUFFER_HDL hOutputBuffer
        );

#if SMS_LOGGING == 1

const char *DATASERVICE_MGR_pacName (
    DATASERVICE_MGR_OBJECT hManager
        );

void DATASERVICE_MGR_vLog (
    const char *pcFormat,
    ...
        );
#else
#if __STDC_VERSION__ >= 199901L
#define DATASERVICE_MGR_vLog(...)
#else
void DATASERVICE_MGR_vLogNothing(
    const char *pcFormat,
    ...
        );
#define DATASERVICE_MGR_vLog if(1);else DATASERVICE_MGR_vLogNothing
#endif
#endif

RADIO_PRIVATE_DATA_OBJECT DATASERVICE_MGR_hGetRadioSpecificData (
    DATASERVICE_MGR_OBJECT hManager
        );

void DATASERVICE_MGR_vSetRadioSpecificData (
    DATASERVICE_MGR_OBJECT hManager,
    RADIO_PRIVATE_DATA_OBJECT hData
        );

BOOLEAN DATASERVICE_MGR_bIterateRadioData (
    SMS_OBJECT hDataCtrl,
    DATASERVICE_RADIO_DATA_ITERATOR bIterator,
    void *pvIteratorArg
        );

DATASERVICE_MGR_OBJECT DATASERVICE_MGR_hFindServiceByDSI (
    SMS_OBJECT hDataCtrl,
    DSI tDSI
        );

DATASERVICE_ID DATASERVICE_MGR_tGetDataId (
    DATASERVICE_MGR_OBJECT hManager
        );

#endif /* DATASERVICE_MGR_OBJ_H_ */
