/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CME header file.
 *
 ******************************************************************************/

#ifndef CME_H_
#define CME_H_

#include "standard.h"
#include "sms_api.h"
#include "cdo_obj.h"
#include "cid_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// The Content Monitoring Engine Object (CME)
typedef struct cme_object * CME_OBJECT;
#define CME_INVALID_OBJECT (CME_OBJECT)NULL

// Content Monitoring Engine Callback definition
typedef void (*CME_CALLBACK) (
    DECODER_OBJECT hDecoder,
    CHANNEL_OBJECT hChannel,
    UN32 un32Flags,
    void *pvEventCallbackArg
        );

// A structure which defines the content registration
typedef struct content_registration_struct
{
    // The CID for which to generate an event on. This is
    // the content which is being specifically registered for.
    CID_OBJECT hCID;

    // Registration options provided by caller
    // (init/end, one-shot, re-trigger, etc.)
    UN32 un32Options;

    // The event callback provided by the caller to call when
    // the provided CID is found.
    CME_CALLBACK vEventCallback;

    // The argument provided by the caller registering this event to
    // provide when calling their registered callback. Callers may
    // use this argument to track, or associate the registered content.
    // It's definition is application specific and must be cast appropriately.
    void *pvEventCallbackArg;

} CONTENT_REGISTRATION_STRUCT;

// Content Monitoring Engine Iterator Callback
typedef BOOLEAN (*CME_ITERATOR_CALLBACK) (
    DECODER_OBJECT hDecoder,
    CONTENT_REGISTRATION_STRUCT *psContent,
    void *pvIteratorCallbackArg
        );

// Content Monitoring Enginer Registered Entry
typedef struct cme_registered_entry *CME_REGISTERED_ENTRY;
#define CME_INVALID_REGISTERED_ENTRY ((CME_REGISTERED_ENTRY)(0))

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

CME_OBJECT CME_hCreate (
    DECODER_OBJECT hDecoder
        );

void CME_vDestroy (
    CME_OBJECT hCME
        );

BOOLEAN CME_bUpdateContent (
    CD_OBJECT hCDO,
    CID_ENUM eNewType,
    const void *pvNewObjectData,
    CID_OBJECT *phCID
        );

BOOLEAN CME_bChangeContent (
    CD_OBJECT hCDO,
    CID_OBJECT hOldCID,
    CID_OBJECT hNewCID
        );

SMSAPI_RETURN_CODE_ENUM CME_eDestroyContent (
    CD_OBJECT hCDO,
    CID_OBJECT *phCID
        );

void CME_vTriggerEvents(
    CME_OBJECT hCME,
    BOOLEAN bBlockUpdateTimer
        );

SMSAPI_RETURN_CODE_ENUM CME_eRegisterContent (
    DECODER_OBJECT hDecoder,
    CID_OBJECT hCID,
    UN32 un32Options,
    CME_CALLBACK vEventCallback,
    void *pvEventCallbackArg,
    CME_REGISTERED_ENTRY *phContentEntry
        );

SMSAPI_RETURN_CODE_ENUM CME_eIterateContent (
    DECODER_OBJECT hDecoder,
    CME_REGISTERED_ENTRY hStartEntry,
    CME_ITERATOR_CALLBACK bContentIterator,
    void *pvContentIteratorArg
        );

SMSAPI_RETURN_CODE_ENUM CME_eReplaceContent(
    DECODER_OBJECT hDecoder,
    UN32 un32Options,
    CME_CALLBACK vEventCallback,
    void *pvEventCallbackArg
        );

SMSAPI_RETURN_CODE_ENUM CME_eRemoveContent(
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM CME_eEnableContent(
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM CME_eDisableContent(
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM CME_eContentEnabled(
    DECODER_OBJECT hDecoder,
    BOOLEAN *pbEnabled
        );

CID_OBJECT CME_hCID(
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM CME_eBlockAllEvents (
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM CME_eUnBlockAllEvents (
    DECODER_OBJECT hDecoder
        );

SMSAPI_RETURN_CODE_ENUM CME_eSearchForCurrent(
    DECODER_OBJECT hDecoder
        );

void CME_vStartTimeoutEventTimer(
    CME_OBJECT hCME
        );

#endif /* CME_H */

