/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CM header file.
 *
 ******************************************************************************/

#ifndef CM_H_
#define CM_H_

#include "standard.h"
#include "osal.h"
#include "tag_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */
SMSAPI_RETURN_CODE_ENUM CM_eInitialize(
    const char *pacConfigFile,
    const char *pacConfigPath,
    const char *pacConfigInitializerFile,
    const char *pacConfigInitialzerPath,
    BOOLEAN *pbConfigFileCreated
        );

void CM_vUninitialize( void );

SMSAPI_RETURN_CODE_ENUM CM_eCommitChangesToFile( void );

BOOLEAN CM_bPendingChanges( void );

SMSAPI_RETURN_CODE_ENUM CM_ePrintTags(
    FILE *psFile
        );

TAG_OBJECT CM_hGetTopTag( void);

STRING_OBJECT CM_hTrueString( void );

STRING_OBJECT CM_hFalseString( void );

SMSAPI_RETURN_CODE_ENUM	CM_eStringToBoolean(
    STRING_OBJECT hString,
    BOOLEAN *pbConvertedValue
        );

#endif // CM_H_

