/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the generic CID INTEGER type header file.
 *
 ******************************************************************************/

#ifndef CID_INTEGER_H_
#define CID_INTEGER_H_

#include "cid_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/
// max integer is 0xFFFFFFFF = 4294967295 which is 10 digits
#define MAX_INTEGER_AS_CHARS   (10)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// External CID Type Interface (INTEGERs) Object Data Interface
extern const CID_TYPE_OBJ_DATA_INTERFACE_STRUCT GsCidIntegerIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

const void *CIDINT_pvCreate (
    const void *pvSrcObjectData,
    size_t tMinimumSize,
    SMS_OBJECT hParent,
    BOOLEAN bConstant
        );

void CIDINT_vDestroy (
    const void *pvObject
        );

const void *CIDINT_pvDuplicate (
    const void *pvObject
        );

BOOLEAN CIDINT_bModify (
    const void **ppvObject,
    const void *pvSrcObjectData
        );

BOOLEAN CIDINT_bCopy (
    void **ppvDstObject,
    const void *pvSrcObject
        );

size_t CIDINT_tSize(
    const void *pvObject
        );

N16 CIDINT_n16Compare (
    const void *pvObject1,
    const void *pvObject2,
    BOOLEAN bBinary
        );

N32 CIDINT_n32FWrite (
    const void *pvObject,
    FILE *psFile
        );

N32 CIDINT_n32FWriteToMemory (
    const void *pvObject,
    void **ppvMemory
        );

const void *CIDINT_pvRead (
    FILE *psFile
        );

BOOLEAN CIDINT_bReadFromMemory(
    const void **ppvObjectData,
    void **ppvMemory,
    SMS_OBJECT hParent
        );

N32 CIDINT_n32FPrintf (
    const void *pvObject,
    FILE *psFile
        );

N32 CIDINT_n32GetValue (
    const void *pvObject,
    void **ppvValue
        );

#endif /* CID_INTEGER_H */
