/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CHANNEL_ART header file.
 *
 ******************************************************************************/

#ifndef CHANNEL_ART_OBJ_H_
#define CHANNEL_ART_OBJ_H_

#include "sms_api.h"
#include "sms_obj.h"
#include "channel_art_db_constants.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Channel Art Object Version
typedef UN32 CHANNEL_ART_VERSION;

typedef enum channel_art_image_assoc_type_enum
{
    CHANNEL_ART_IMAGE_ASSOC_TYPE_CONTENT,
    CHANNEL_ART_IMAGE_ASSOC_TYPE_STATIC,
    CHANNEL_ART_IMAGE_ASSOC_TYPE_UNKNOWN

} CHANNEL_ART_IMAGE_ASSOC_TYPE_ENUM;

typedef BOOLEAN (*CHANNEL_ART_ASSOC_TYPE_ITERATOR) (
    CHANNEL_ART_IMAGE_ASSOC_TYPE_ENUM eAssocType,
    void *pvCallbackArg
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

// TODO: how can we handle this file path business better?
CHANNEL_ART_OBJECT CHANNEL_ART_hCreate (
    SMS_OBJECT hOwner,
    const char *pacFilePath
        );

CHANNEL_ART_OBJECT CHANNEL_ART_hCopy (
    SMS_OBJECT hOwner,
    CHANNEL_ART_OBJECT hChannelArt
        );

IMAGE_OBJECT CHANNEL_ART_hImage (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_IMAGETYPE_ENUM eImageType
        );

void CHANNEL_ART_vDestroy (
    CHANNEL_ART_OBJECT hChannelArt
        );

BOOLEAN CHANNEL_ART_bSetChannelImage (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_ASSOC_ROW_STRUCT *psAssocRow,
    CHANNEL_ART_ATTRIB_ROW_STRUCT *psImageAttribs,
    BOOLEAN *pbImageUpdated
        );

BOOLEAN CHANNEL_ART_bSetAlbumImage (
    CHANNEL_ART_OBJECT hChannelArt,
    ALBUM_ART_ASSOC_ROW_STRUCT *psAssocRow,
    STRING_OBJECT *phCaption,
    BOOLEAN *pbImageUpdated
        );

BOOLEAN CHANNEL_ART_bUpdateImageAttributes (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_ATTRIB_ROW_STRUCT *psImageAttribs
        );

BOOLEAN CHANNEL_ART_bRemoveImage (
    CHANNEL_ART_OBJECT hChannelArt,
    BOOLEAN bContentAssociation,
    CHANNEL_ART_IMAGETYPE_ENUM eImageType
        );

BOOLEAN CHANNEL_ART_bCopyAllImages (
    CHANNEL_ART_OBJECT hChannelArtDst,
    CHANNEL_ART_OBJECT hChannelArtSrc
        );

BOOLEAN CHANNEL_ART_bCopyImage (
    CHANNEL_ART_OBJECT hChannelArtDst,
    CHANNEL_ART_OBJECT hChannelArtSrc,
    BOOLEAN bContentAssociation,
    CHANNEL_ART_IMAGETYPE_ENUM eImageType
        );

BOOLEAN CHANNEL_ART_bReset (
    CHANNEL_ART_OBJECT hChannelArt,
    BOOLEAN bContentArtOnly
        );

BOOLEAN CHANNEL_ART_bImageSource (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_OBJECT hChannelArtQuery,
    BOOLEAN bContentArt,
    CHANNEL_ART_IMAGETYPE_ENUM eImageType,
    BOOLEAN *pbImageTypePresent
        );

BOOLEAN CHANNEL_ART_bHasImage (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_ATTRIB_ROW_STRUCT *psAttrib
        );

BOOLEAN CHANNEL_ART_bGetImageAttributes (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_IMAGE_ASSOC_TYPE_ENUM eImageAssocType,
    CHANNEL_ART_ATTRIB_ROW_STRUCT *psImageAttribs,
    BOOLEAN *pbImageCopied
        );

BOOLEAN CHANNEL_ART_bAssociationTypesForImage(
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_ATTRIB_ROW_STRUCT *psImageAttribs,
    CHANNEL_ART_ASSOC_TYPE_ITERATOR bIterator,
    void *pvArg
        );

BOOLEAN CHANNEL_ART_bGetAssocAttributes (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_IMAGE_ASSOC_TYPE_ENUM eImageAssocType,
    UN8 un8ImageType,
    CHANNEL_ART_ASSOC_ROW_STRUCT *psAssocRow
        );

void CHANNEL_ART_vConfirmAssociation (
    CHANNEL_ART_OBJECT hChannelArt,
    CHANNEL_ART_IMAGE_ASSOC_TYPE_ENUM eImageAssocType,
    UN8 un8ImageType
        );

CHANNEL_ART_AVAILABLE_IMAGE_MASK CHANNEL_ART_tImagesAvailable (
    CHANNEL_ART_OBJECT hChannelArt
        );

CHANNEL_ART_VERSION CHANNEL_ART_tVersion (
    CHANNEL_ART_OBJECT hChannelArt
        );

#endif /* CHANNEL_ART_OBJ_H_ */
