/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:CHANNEL_ART_MGR header file.
 *
 ******************************************************************************/

#ifndef CHANNEL_ART_MGR_OBJ_H_
#define CHANNEL_ART_MGR_OBJ_H_

#include "sms_api.h"
#include "sms_event.h"
#include "channel_art_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#define CHANNEL_ART_SECONDARY_LOGO_BK_OPTIONS (CHANNEL_ART_BACKGROUND_OPTION_NONE)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

CHANNEL_ART_OBJECT CHANNEL_ART_MGR_hGetArtForServiceId (
    CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
    SERVICE_ID tServiceId,
    CHANNEL_ART_VERSION* ptArtVersion
        );

CHANNEL_ART_OBJECT CHANNEL_ART_MGR_hGetArtForCategoryId (
    CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
    CATEGORY_ID tCategoryId
        );

CHANNEL_ART_OBJECT CHANNEL_ART_MGR_hGetArtForCDO (
    CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
    SERVICE_ID tServiceId,
    PROGRAM_ID tProgramID,
    CDO_TYPE_ENUM eType
        );

void CHANNEL_ART_vDecoderEventHandler (
    DECODER_OBJECT hDecoder,
    SMS_EVENT_ART_STRUCT const *psArt
        );

size_t CHANNEL_ART_MGR_tChannelArtImageFilenameLen (
    IMAGE_FORMAT_ENUM eFormat,
    CHANNEL_ART_IMAGETYPE_ENUM eImageType,
    const char *pacFilePath
        );

size_t CHANNEL_ART_MGR_tAlbumArtImageFilenameLen (
    IMAGE_FORMAT_ENUM eFormat,
    CHANNEL_ART_IMAGETYPE_ENUM eImageType,
    const char *pacFilePath
        );

BOOLEAN CHANNEL_ART_MGR_bChannelArtCreateImageFilename (
    UN16 un16ImageId,
    UN16 un16ImageVer,
    CHANNEL_ART_IMAGETYPE_ENUM eImageType,
    IMAGE_FORMAT_ENUM eFormat,
    const char *pacFilePath,
    char *pacBuffer,
    size_t tBufferSize
        );

BOOLEAN CHANNEL_ART_MGR_bAlbumArtCreateImageFilename (
    UN16 un16ImageId,
    UN16 un16ImageVer,
    const char *pacFilePath,
    char *pacBuffer,
    size_t tBufferSize
        );

#if 0
// Reserved for future "safe-to-delete" functionality
void CHANNEL_ART_MGR_vAlbumArtRemoveAssoc (
    CHANNEL_ART_SERVICE_OBJECT hChannelArtService,
    UN16 un16Source,
    UN32 un32ProgramId
        );
#endif

#endif /* CHANNEL_ART_MGR_OBJ_H_ */
