/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This module contains the Object:CAR implementation for the
 *  Sirius Module Services (SMS)
 *
******************************************************************************/
#include <stdio.h>
#include <string.h>

#include "standard.h"
#include "osal.h"

#include "sms_version.h"
#include "sms_api.h"
#include "car_obj.h"
#include "_car_obj.h"

/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/

#ifdef SXM_LEGACY_SSP
/*****************************************************************************
*
*   hCreate
*
* Create a Car Object.
*
*****************************************************************************/
static CAR_OBJECT hCreate(
           LEAGUE_ENUM eLeague,
           CID_OBJECT hCarId,
           const char *pacCarNumber,
           const char *pacDriverName,
           const char *pacNickname
               )
{
    return (CAR_OBJECT)TEAM.hCreate(
        eLeague, hCarId, pacCarNumber, pacDriverName, pacNickname);
}
#endif

/*****************************************************************************
*
*   pacDriverName
*
* Retrieve the driver name given the provided CAR_OBJECT handle. The name
* is returned as a constant null terminated string.
*
*****************************************************************************/
static STRING_OBJECT hDriverName (
    CAR_OBJECT hCar
        )
{
    return TEAM.hName((TEAM_OBJECT)hCar);
}

/*****************************************************************************
*
*   pacCarNumber
*
* Retrieve the team car number given the provided CAR_OBJECT handle.
* The car number is returned as a constant null terminated string.
*
*****************************************************************************/
static STRING_OBJECT hCarNumber (
    CAR_OBJECT hCar
        )
{
    return TEAM.hAbbreviation((TEAM_OBJECT)hCar);
}

/*****************************************************************************
*
*   bIterateContent
*
* Iterates the available TEAMs within a provided LEAGUE. For each available
* TEAM the caller's provided callback and callback argument are called.
* Note that all TEAM_OBJECTs are created
* at SMS initialization, are constant and exist throughout the life of SMS.
* Thus any provided TEAM_OBJECT handle is always valid in any context
* for which the API is called. Thus no exclusive access is required.
*
*****************************************************************************/
static BOOLEAN bIterateContent (
    LEAGUE_OBJECT hLeague,
    CAR_CONTENT_ITERATOR_CALLBACK bContentIteratorCallback,
    void *pvContentIteratorCallbackArg
        )
{
    BOOLEAN bRetval = FALSE;

    // Input league must be Auto-racing
    if(LEAGUE.eLeague(hLeague) == LEAGUE_AUTORACING)
    {
        // Iterate this team(car list)
        bRetval = TEAM.bIterateContent(
            hLeague,
            bContentIteratorCallback,
            pvContentIteratorCallbackArg
                );
    }

    return bRetval;
}

/*****************************************************************************
                             FRIEND FUNCTIONS
*****************************************************************************/

/*****************************************************************************
                             PRIVATE FUNCTIONS
*****************************************************************************/







