/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the browse object header file.
 *
 ******************************************************************************/

#ifndef BROWSE_OBJ_H_
#define BROWSE_OBJ_H_

#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Object handle
typedef void * BROWSE_OBJECT;
#define BROWSE_INVALID_OBJECT (BROWSE_OBJECT)NULL

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

BROWSE_OBJECT BROWSE_hCreate (
    SMS_OBJECT hOwner,
    DECODER_OBJECT hDecoder
        );

void BROWSE_vDestroy (
    BROWSE_OBJECT hBrowse
        );

BROWSE_TYPE_ENUM BROWSE_eGetMode (
    BROWSE_OBJECT hBrowse
        );

BOOLEAN BROWSE_bSetMode (
    BROWSE_OBJECT hBrowse,
    BROWSE_TYPE_ENUM eBrowseType,
    CHANNEL_ID tReferenceChannelId,
    CATEGORY_ID tReferenceCategoryId
        );

BOOLEAN BROWSE_bRefresh (
    BROWSE_OBJECT hBrowse
        );

BOOLEAN BROWSE_bGetBrowsed (
    BROWSE_OBJECT hBrowse,
    CHANNEL_ID *ptBrowsedChannelId,
    CATEGORY_ID *ptBrowsedCategoryId
        );

N16 BROWSE_n16GetBrowsedChannelOffset (
    BROWSE_OBJECT hBrowse
        );

BOOLEAN BROWSE_bSetChannelBrowseStyle (
    BROWSE_OBJECT hBrowse,
    BROWSE_CHANNEL_COMPARE_HANDLER bBrowseChannelCompareHandler,
    void *pvBrowseChannelCompareArg
        );

BOOLEAN BROWSE_bSetCategoryBrowseStyle (
    BROWSE_OBJECT hBrowse,
    BROWSE_CATEGORY_COMPARE_HANDLER bBrowseCategoryCompareHandler,
    void *pvBrowseCategoryCompareArg
        );

BOOLEAN BROWSE_bBrowse (
    BROWSE_OBJECT hBrowse,
    SMSAPI_DIRECTION_ENUM eDirection,
    BOOLEAN bBrowseChannel,
    CHANNEL_ID *ptChannelId,
    CATEGORY_ID *ptCategoryId,
    BOOLEAN bBrowsingChanlist
        );

BOOLEAN BROWSE_bTryBrowse (
    BROWSE_OBJECT hBrowse,
    CHANNEL_ID tChannelId,
    CATEGORY_ID tCategoryId
        );

#endif /* BROWSE_OBJ_H_ */
