/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the BAUDOT header file.
 *
 ******************************************************************************/

#ifndef BAUDOT_H_
#define BAUDOT_H_

#include "osal.h"
#include "sms_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// Number of bits per baudot character
#define BAUDOT_CHAR_BITWIDTH (5)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef UN8 BAUDOT_CHAR;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

STRING_OBJECT BAUDOT_hToString (
    SMS_OBJECT hStringOwner,
    OSAL_BUFFER_HDL hBuffer,
    BAUDOT_BEHAVIOR_ENUM eProcessBehavior,
    BOOLEAN bStringStartsWithLetters,
    BOOLEAN bStringStartsWithCaps,
    size_t tMaxBaudotSymbolsToRead,
    size_t *ptNumSymbolsFound
        );

#endif /* BAUDOT_H_ */
